/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.struct.TwoValues;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StringAdvice {
    public static boolean isEmpty(String content) {
        return content == null || content.isEmpty();
    }

    public static boolean isNotEmpty(String content) {
        return content != null && !content.isEmpty();
    }

    public static String defaultEmpty(String content) {
        return content != null ? content : "";
    }

    public static String emptyOr(String content, String defaultValue) {
        return StringAdvice.isEmpty(content) ? defaultValue : content;
    }

    public static String headTail(String content, String sign) {
        return sign + content + sign;
    }

    public static TwoValues<String, String> cutOff(String string, int index) {
        if (index > string.length() || index < 0) {
            return null;
        }
        return TwoValues.of(string.substring(0, index), string.substring(index));
    }

    public static String cutTail(String string, String tail) {
        return string.endsWith(tail) ? string.substring(0, string.length() - tail.length()) : string;
    }

    public static String cutHead(String string, String head) {
        return string.startsWith(head) ? string.substring(head.length()) : string;
    }

    public static List<String> regexMatch(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> list = new ArrayList<String>(matcher.groupCount());
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static List<String> regexMatchStartEnd(String string, String start, String end) {
        return StringAdvice.regexMatch(string, String.format("(?<=%s)(.+?)(?=%s)", start, end));
    }

    public static String intervalFormat(String separator, Object ... objs) {
        return Stream.of(objs).map(o -> o == null ? "null" : o.toString()).collect(Collectors.joining(separator));
    }

    public static String urlParametersFormat(Map<String, Object> parameters, boolean needQuestionMark) {
        if (parameters.isEmpty()) {
            return "";
        }
        return (needQuestionMark ? "?" : "") + parameters.entrySet().stream().filter(kv -> kv.getValue() != null).map(kv -> String.format("%s=%s", kv.getKey(), URLEncoder.encode(kv.getValue().toString(), StandardCharsets.UTF_8))).collect(Collectors.joining("&"));
    }

    public static String trim(String str, char ch) {
        if (str == null) {
            return null;
        }
        int leftSkip = 0;
        int rightSkip = 0;
        int len = str.length();
        boolean left = true;
        boolean right = true;
        for (int i = 0; i < len && (left || right); ++i) {
            if (left && (left = str.charAt(i) == ch)) {
                ++leftSkip;
            }
            if (!right || !(right = str.charAt(len - 1 - i) == ch)) continue;
            ++rightSkip;
        }
        return str.substring(leftSkip, len - rightSkip);
    }
}

