/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import develop.toolkit.base.components.HttpClientHelper;
import develop.toolkit.base.struct.http.HttpClientReceiver;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ConcurrentTesting {
    private final ExecutorService service;
    private final int cycleCount;
    private final int triggerCount;
    private final int interval;
    private final HttpClientHelper helper;

    public ConcurrentTesting(int threadCount, int triggerCount, int cycleCount, int interval) {
        this.helper = HttpClientHelper.buildDefault();
        this.service = Executors.newFixedThreadPool(threadCount);
        this.triggerCount = triggerCount;
        this.cycleCount = cycleCount;
        this.interval = interval;
    }

    public ConcurrentTesting(HttpClientHelper helper, int threadCount, int triggerCount, int cycleCount, int interval) {
        this.helper = helper;
        this.service = Executors.newFixedThreadPool(threadCount);
        this.triggerCount = triggerCount;
        this.cycleCount = cycleCount;
        this.interval = interval;
    }

    public void start(Function<HttpClientHelper, HttpClientReceiver<String>> function) {
        this.start(function, receiver -> System.out.printf("\u3010%s\u3011%s\t%s%n", Thread.currentThread().getName(), receiver.getHttpStatus(), receiver.getBody()));
    }

    public void start(Function<HttpClientHelper, HttpClientReceiver<String>> function, Consumer<HttpClientReceiver<String>> consumer) {
        for (int i = 0; i < this.triggerCount; ++i) {
            this.service.execute(() -> {
                for (int j = 0; j < this.cycleCount; ++j) {
                    if (this.interval > 0) {
                        try {
                            Thread.sleep(this.interval);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    consumer.accept((HttpClientReceiver)function.apply(this.helper));
                }
            });
        }
        this.service.shutdown();
    }
}

