/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import develop.toolkit.base.struct.http.ByteRequestBody;
import develop.toolkit.base.struct.http.FormUrlencodedBody;
import develop.toolkit.base.struct.http.HttpClientConstants;
import develop.toolkit.base.struct.http.HttpClientGlobalOptions;
import develop.toolkit.base.struct.http.HttpClientReceiver;
import develop.toolkit.base.struct.http.HttpPostProcessor;
import develop.toolkit.base.struct.http.HttpRequestBody;
import develop.toolkit.base.struct.http.MultiPartFormDataBody;
import develop.toolkit.base.struct.http.RawRequestBody;
import develop.toolkit.base.struct.http.SenderHandler;
import develop.toolkit.base.struct.http.StringBodySenderHandler;
import develop.toolkit.base.utils.K;
import develop.toolkit.base.utils.StringAdvice;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class HttpClientSender {
    private final HttpClient httpClient;
    private final String method;
    private final String url;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private final List<HttpPostProcessor> postProcessors;
    private Duration readTimeout;
    private String debugLabel;
    private HttpRequestBody<?> requestBody;
    private String requestStringBody;
    private boolean onlyPrintFailed;
    private URI uri;
    private final HttpClientConstants constants;

    protected HttpClientSender(HttpClient httpClient, String method, String url, HttpClientGlobalOptions options) {
        this.httpClient = httpClient;
        this.method = method;
        this.readTimeout = options.readTimeout;
        this.postProcessors = new LinkedList<HttpPostProcessor>(options.postProcessors);
        this.constants = options.constants;
        this.onlyPrintFailed = options.onlyPrintFailed;
        this.url = this.constants.replace(url);
    }

    public HttpClientSender header(String header, String value) {
        this.headers.put(header, this.constants.replace(value));
        return this;
    }

    public HttpClientSender headers(Map<String, String> customHeaders) {
        if (customHeaders != null) {
            customHeaders.forEach((k, v) -> this.headers.put((String)k, this.constants.replace((String)v)));
        }
        return this;
    }

    public HttpClientSender headerAuthorization(String value) {
        this.headers.put("Authorization", this.constants.replace(value));
        return this;
    }

    public HttpClientSender headerContentType(String contentType) {
        this.headers.put("Content-Type", contentType);
        return this;
    }

    public HttpClientSender parameter(String parameter, Object value) {
        this.parameters.put(parameter, value);
        return this;
    }

    public HttpClientSender parameters(Map<String, Object> parameterMap) {
        if (parameterMap != null) {
            parameterMap.forEach((k, v) -> {
                if (v instanceof String) {
                    this.parameters.put((String)k, this.constants.replace((String)v));
                } else {
                    this.parameters.put((String)k, v);
                }
            });
        }
        return this;
    }

    public HttpClientSender readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpClientSender debugLabel(String debugLabel) {
        this.debugLabel = debugLabel;
        return this;
    }

    public HttpClientSender onlyPrintFailed(boolean onlyPrintFailed) {
        this.onlyPrintFailed = onlyPrintFailed;
        return this;
    }

    public HttpClientSender addPostProcessor(HttpPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
        return this;
    }

    public HttpClientSender bodyJson(String json) {
        this.headers.put("Content-Type", "application/json;charset=utf-8");
        this.requestBody = K.map(json, RawRequestBody::new);
        return this;
    }

    public HttpClientSender bodyXml(String xml) {
        this.headers.put("Content-Type", "application/xml;charset=utf-8");
        this.requestBody = K.map(xml, RawRequestBody::new);
        return this;
    }

    public HttpClientSender bodyText(String text) {
        this.headers.put("Content-Type", "text/plain;charset=utf-8");
        this.requestBody = K.map(text, RawRequestBody::new);
        return this;
    }

    public HttpClientSender bodyBytes(byte[] bytes) {
        this.requestBody = K.map(bytes, ByteRequestBody::new);
        return this;
    }

    public HttpClientSender bodyMultiPartFormData(MultiPartFormDataBody multiPartFormDataBody) {
        this.headers.put("Content-Type", "multipart/form-data; boundary=" + multiPartFormDataBody.getBoundary());
        this.requestBody = multiPartFormDataBody;
        return this;
    }

    public HttpClientSender bodyFormUrlencoded(FormUrlencodedBody formUrlencodedBody) {
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.requestBody = formUrlencodedBody;
        return this;
    }

    public void download(Path path, OpenOption ... openOptions) {
        this.send(HttpResponse.BodyHandlers::ofByteArray).ifSuccess(r -> r.save(path, openOptions));
    }

    public HttpClientReceiver<String> send() {
        return this.send(new StringBodySenderHandler());
    }

    public CompletableFuture<HttpClientReceiver<String>> sendAsync() {
        return this.sendAsync(new StringBodySenderHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <BODY> HttpClientReceiver<BODY> send(SenderHandler<BODY> senderHandler) {
        this.uri = URI.create(this.url + StringAdvice.urlParametersFormat(this.parameters, true));
        HttpRequest.Builder builder = HttpRequest.newBuilder().version(this.httpClient.version()).uri(this.uri);
        this.headers.forEach(builder::header);
        HttpRequest request = builder.method(this.method, senderHandler.bodyPublisher(this.requestBody)).timeout(this.readTimeout).build();
        this.requestStringBody = HttpRequestBody.bodyToString(this.requestBody);
        HttpClientReceiver<BODY> receiver = new HttpClientReceiver<BODY>();
        Instant start = Instant.now();
        try {
            HttpResponse<BODY> response = this.httpClient.send(request, senderHandler.bodyHandler());
            receiver.setHttpStatus(response.statusCode());
            receiver.setHeaders(response.headers().map());
            receiver.setBody(response.body());
        }
        catch (HttpConnectTimeoutException e) {
            receiver.setConnectTimeout(true);
        }
        catch (HttpTimeoutException e) {
            receiver.setReadTimeout(true);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            receiver.setErrorMessage(e.getMessage());
        }
        finally {
            receiver.setCostTime(start.until(Instant.now(), ChronoUnit.MILLIS));
            this.doPostProcessors(receiver);
        }
        return receiver;
    }

    public <BODY> CompletableFuture<HttpClientReceiver<BODY>> sendAsync(SenderHandler<BODY> senderHandler) {
        this.uri = URI.create(this.url + StringAdvice.urlParametersFormat(this.parameters, true));
        HttpRequest.Builder builder = HttpRequest.newBuilder().version(this.httpClient.version()).uri(this.uri);
        this.headers.forEach(builder::header);
        HttpRequest request = builder.method(this.method, senderHandler.bodyPublisher(this.requestBody)).timeout(this.readTimeout).build();
        this.requestStringBody = HttpRequestBody.bodyToString(this.requestBody);
        Instant start = Instant.now();
        return this.httpClient.sendAsync(request, senderHandler.bodyHandler()).handle((response, e) -> {
            HttpClientReceiver receiver = new HttpClientReceiver();
            if (e == null) {
                receiver.setHttpStatus(response.statusCode());
                receiver.setHeaders(response.headers().map());
                receiver.setBody(response.body());
            } else if (e instanceof HttpConnectTimeoutException) {
                receiver.setConnectTimeout(true);
            } else if (e instanceof HttpTimeoutException) {
                receiver.setReadTimeout(true);
            } else if (e instanceof InterruptedException || e instanceof IOException) {
                e.printStackTrace();
                receiver.setErrorMessage(e.getMessage());
            }
            receiver.setCostTime(start.until(Instant.now(), ChronoUnit.MILLIS));
            this.doPostProcessors(receiver);
            return receiver;
        });
    }

    private <BODY> void doPostProcessors(HttpClientReceiver<BODY> receiver) {
        for (HttpPostProcessor postProcessor : this.postProcessors) {
            postProcessor.process(this, receiver);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public List<HttpPostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public String getDebugLabel() {
        return this.debugLabel;
    }

    public HttpRequestBody<?> getRequestBody() {
        return this.requestBody;
    }

    public String getRequestStringBody() {
        return this.requestStringBody;
    }

    public boolean isOnlyPrintFailed() {
        return this.onlyPrintFailed;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpClientConstants getConstants() {
        return this.constants;
    }
}

