/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class IWantData<T> {
    private final boolean success;
    private final String message;
    private final T data;

    public static <T> IWantData<T> ok(T data) {
        return new IWantData<T>(true, null, data);
    }

    public static IWantData<Void> ok() {
        return IWantData.ok(null);
    }

    public static <T> IWantData<T> fail(String message) {
        return new IWantData<Object>(false, message, null);
    }

    public <R> IWantData<R> map(Function<? super T, ? extends R> function) {
        return this.success ? IWantData.ok(function.apply(this.data)) : IWantData.fail(this.message);
    }

    public <R> IWantData<R> flatMap(Function<? super T, IWantData<R>> function) {
        return this.success ? function.apply(this.data) : IWantData.fail(this.message);
    }

    public T returnData(T defaultValue, Consumer<String> messageConsumer) {
        if (this.success) {
            return this.data;
        }
        if (messageConsumer != null) {
            messageConsumer.accept(this.message);
        }
        return defaultValue;
    }

    public T returnData(Supplier<T> defaultSupplier, Consumer<String> messageConsumer) {
        if (this.success) {
            return this.data;
        }
        if (messageConsumer != null) {
            messageConsumer.accept(this.message);
        }
        return defaultSupplier.get();
    }

    public T returnDataThrows(Function<String, ? extends RuntimeException> throwableFunction) {
        if (this.success) {
            return this.data;
        }
        throw throwableFunction.apply(this.message);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    private IWantData(boolean success, String message, T data) {
        this.success = success;
        this.message = message;
        this.data = data;
    }
}

