/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import java.time.Instant;

public class SnowflakeIdWorker {
    private final long workerIdBits = 5L;
    private final long datacenterIdBits = 5L;
    private final long workerId;
    private final long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowflakeIdWorker(long workerId, long datacenterId) {
        long maxWorkerId = 31L;
        if (workerId > maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", maxWorkerId));
        }
        long maxDatacenterId = 31L;
        if (datacenterId > maxDatacenterId || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", maxDatacenterId));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        long sequenceBits = 12L;
        if (this.lastTimestamp == timestamp) {
            long sequenceMask = -1L << (int)sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
            this.sequence = this.sequence + 1L & sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long datacenterIdShift = sequenceBits + 5L;
        long timestampLeftShift = sequenceBits + 5L + 5L;
        long twepoch = 1577808000000L;
        return timestamp - twepoch << (int)timestampLeftShift | this.datacenterId << (int)datacenterIdShift | this.workerId << (int)sequenceBits | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return Instant.now().toEpochMilli();
    }
}

