/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import develop.toolkit.base.utils.DateTimeAdvice;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class StopWatch {
    public static final String DEFAULT_NAME = "default";
    private final Map<String, Instant> startInstantMap = new ConcurrentHashMap<String, Instant>();

    private StopWatch(String name) {
        this.pause(name);
    }

    public void pause(String name) {
        this.startInstantMap.put(name, Instant.now());
    }

    public long end() {
        return this.end(DEFAULT_NAME);
    }

    public long end(String name) {
        return this.startInstantMap.get(name).until(Instant.now(), ChronoUnit.MILLIS);
    }

    public long interval(String startName, String endName) {
        return this.startInstantMap.get(startName).until(this.startInstantMap.get(endName), ChronoUnit.MILLIS);
    }

    public String formatEnd() {
        return DateTimeAdvice.millisecondPretty(this.end());
    }

    public String formatEnd(String label) {
        return label + ": " + DateTimeAdvice.millisecondPretty(this.end());
    }

    public String formatEnd(String label, String name) {
        return label + ": " + DateTimeAdvice.millisecondPretty(this.end(name));
    }

    public static StopWatch start() {
        return new StopWatch(DEFAULT_NAME);
    }

    public static StopWatch start(String name) {
        return new StopWatch(name);
    }
}

