/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct;

import java.io.InputStream;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;

public class ZipWrapper {
    private String filename;
    private Supplier<InputStream> inputStreamSupplier;
    private boolean file;
    private List<ZipWrapper> children;
    private boolean stored;
    private long compressedSize;
    private long size;
    private long crc;
    private FileTime creationTime;
    private FileTime lastAccessTime;
    private FileTime lastModifyTime;
    private long time;
    private String comment;
    private LocalDateTime timeLocal;
    private byte[] extra;

    public void configureZipEntry(ZipEntry zipEntry) {
        zipEntry.setMethod(this.stored ? 0 : 8);
        zipEntry.setCompressedSize(this.compressedSize);
        zipEntry.setSize(this.size);
        zipEntry.setCrc(this.crc);
        zipEntry.setCreationTime(this.creationTime);
        zipEntry.setLastAccessTime(this.lastAccessTime);
        zipEntry.setLastModifiedTime(this.lastModifyTime);
        zipEntry.setTime(this.time);
        zipEntry.setTimeLocal(this.timeLocal);
        zipEntry.setExtra(this.extra);
        zipEntry.setComment(this.comment);
    }

    public String getFilename() {
        return this.filename;
    }

    public Supplier<InputStream> getInputStreamSupplier() {
        return this.inputStreamSupplier;
    }

    public boolean isFile() {
        return this.file;
    }

    public List<ZipWrapper> getChildren() {
        return this.children;
    }

    public boolean isStored() {
        return this.stored;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getSize() {
        return this.size;
    }

    public long getCrc() {
        return this.crc;
    }

    public FileTime getCreationTime() {
        return this.creationTime;
    }

    public FileTime getLastAccessTime() {
        return this.lastAccessTime;
    }

    public FileTime getLastModifyTime() {
        return this.lastModifyTime;
    }

    public long getTime() {
        return this.time;
    }

    public String getComment() {
        return this.comment;
    }

    public LocalDateTime getTimeLocal() {
        return this.timeLocal;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setInputStreamSupplier(Supplier<InputStream> inputStreamSupplier) {
        this.inputStreamSupplier = inputStreamSupplier;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public void setChildren(List<ZipWrapper> children) {
        this.children = children;
    }

    public void setStored(boolean stored) {
        this.stored = stored;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }

    public void setCreationTime(FileTime creationTime) {
        this.creationTime = creationTime;
    }

    public void setLastAccessTime(FileTime lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public void setLastModifyTime(FileTime lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTimeLocal(LocalDateTime timeLocal) {
        this.timeLocal = timeLocal;
    }

    public void setExtra(byte[] extra) {
        this.extra = extra;
    }
}

