/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct.http;

import develop.toolkit.base.utils.IOAdvice;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public final class HttpClientReceiver<T> {
    private int httpStatus;
    private Map<String, List<String>> headers;
    private T body;
    private long costTime;
    private boolean connectTimeout;
    private boolean readTimeout;
    private String errorMessage;

    public String getHeader(String header) {
        return StringUtils.join((Iterable)this.headers.getOrDefault(header, List.of()), (String)";");
    }

    public boolean isTimeout() {
        return this.connectTimeout || this.readTimeout;
    }

    public boolean isSuccess() {
        return this.errorMessage == null && !this.isTimeout() && this.httpStatus >= 200 && this.httpStatus < 300;
    }

    public void ifSuccess(Consumer<HttpClientReceiver<T>> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this);
        }
    }

    public void save(Path path, OpenOption ... openOptions) {
        byte[] data;
        if (this.body instanceof InputStream) {
            data = IOAdvice.toByteArray((InputStream)this.body);
        } else if (this.body.getClass().isArray()) {
            data = (byte[])this.body;
        } else if (this.body instanceof String) {
            data = ((String)this.body).getBytes();
        } else {
            throw new IllegalArgumentException();
        }
        try {
            Files.write(path, data, openOptions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public T getBody() {
        return this.body;
    }

    public long getCostTime() {
        return this.costTime;
    }

    public boolean isConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isReadTimeout() {
        return this.readTimeout;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public void setCostTime(long costTime) {
        this.costTime = costTime;
    }

    public void setConnectTimeout(boolean connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(boolean readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

