/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct.http;

import develop.toolkit.base.struct.http.HttpRequestBody;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.RandomStringUtils;

public final class MultiPartFormDataBody
implements HttpRequestBody<byte[]> {
    private final List<PartsSpecification> partsSpecificationList = new ArrayList<PartsSpecification>();
    private final String boundary = RandomStringUtils.randomAlphabetic((int)10);

    @Override
    public byte[] getBody() {
        if (this.partsSpecificationList.isEmpty()) {
            return new byte[0];
        }
        this.addFinalBoundaryPart();
        return this.assemble();
    }

    public String toString() {
        return "(Binary byte data)";
    }

    public MultiPartFormDataBody addPart(String name, String value) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.STRING;
        newPart.name = name;
        newPart.value = value;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    public MultiPartFormDataBody addPart(String name, Path path) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.FILE;
        newPart.name = name;
        newPart.path = path;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    public MultiPartFormDataBody addPart(String name, String filename, String contentType, byte[] bytes) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.BYTES;
        newPart.name = name;
        newPart.bytes = bytes;
        newPart.filename = filename;
        newPart.contentType = contentType;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    public MultiPartFormDataBody addPart(String name, String filename, String contentType, Supplier<InputStream> stream) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.STREAM;
        newPart.name = name;
        newPart.stream = stream;
        newPart.filename = filename;
        newPart.contentType = contentType;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    private void addFinalBoundaryPart() {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.FINAL_BOUNDARY;
        newPart.value = "--" + this.boundary + "--";
        this.partsSpecificationList.add(newPart);
    }

    private byte[] assemble() {
        int length = 0;
        int pos = 0;
        PartsIterator iteratorForCount = new PartsIterator();
        while (iteratorForCount.hasNext()) {
            length += iteratorForCount.next().length;
        }
        byte[] data = new byte[length];
        PartsIterator iteratorForBytes = new PartsIterator();
        while (iteratorForBytes.hasNext()) {
            byte[] nextBytes = iteratorForBytes.next();
            System.arraycopy(nextBytes, 0, data, pos, nextBytes.length);
            pos += nextBytes.length;
        }
        return data;
    }

    public String getBoundary() {
        return this.boundary;
    }

    private static class PartsSpecification {
        public Type type;
        public String name;
        public String value;
        public Path path;
        public byte[] bytes;
        public Supplier<InputStream> stream;
        public String filename;
        public String contentType;

        private PartsSpecification() {
        }

        public static enum Type {
            STRING,
            FILE,
            BYTES,
            STREAM,
            FINAL_BOUNDARY;

        }
    }

    private class PartsIterator
    implements Iterator<byte[]> {
        private final Iterator<PartsSpecification> iterator;
        private InputStream currentInputStream;
        private byte[] nextBytes;
        private static final String NEW_LINE = "\r\n";

        private PartsIterator() {
            this.iterator = MultiPartFormDataBody.this.partsSpecificationList.iterator();
        }

        @Override
        public boolean hasNext() {
            try {
                this.nextBytes = this.currentInputStream == null ? this.determineNextPart() : this.readCurrentInputStream();
                return this.nextBytes != null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public byte[] next() {
            byte[] result = this.nextBytes;
            this.nextBytes = null;
            return result;
        }

        private byte[] determineNextPart() throws IOException {
            if (!this.iterator.hasNext()) {
                return null;
            }
            PartsSpecification nextPart = this.iterator.next();
            switch (nextPart.type) {
                case FINAL_BOUNDARY: {
                    return nextPart.value.getBytes(StandardCharsets.UTF_8);
                }
                case STRING: {
                    this.currentInputStream = new ByteArrayInputStream(nextPart.value.getBytes(StandardCharsets.UTF_8));
                    return this.headerBytes(nextPart.name, null, "text/plain; charset=UTF-8");
                }
                case BYTES: {
                    this.currentInputStream = new ByteArrayInputStream(nextPart.bytes);
                    return this.headerBytes(nextPart.name, nextPart.filename, nextPart.contentType);
                }
                case FILE: {
                    this.currentInputStream = Files.newInputStream(nextPart.path, new OpenOption[0]);
                    return this.headerBytes(nextPart.name, nextPart.path.getFileName().toString(), Files.probeContentType(nextPart.path));
                }
                case STREAM: {
                    this.currentInputStream = nextPart.stream.get();
                    return this.headerBytes(nextPart.name, nextPart.filename, nextPart.contentType);
                }
            }
            throw new AssertionError();
        }

        private byte[] readCurrentInputStream() throws IOException {
            byte[] buffer = new byte[8192];
            int r = this.currentInputStream.read(buffer);
            if (r > 0) {
                byte[] actualBytes = new byte[r];
                System.arraycopy(buffer, 0, actualBytes, 0, r);
                return actualBytes;
            }
            this.currentInputStream.close();
            this.currentInputStream = null;
            return NEW_LINE.getBytes();
        }

        private byte[] headerBytes(String name, String filename, String contentType) {
            StringBuilder sb = new StringBuilder("--").append(MultiPartFormDataBody.this.boundary).append(NEW_LINE).append("Content-Disposition: form-data; name=").append(name);
            if (filename != null) {
                sb.append("; filename=").append(filename);
            }
            sb.append(NEW_LINE).append("Content-Type: ").append(contentType).append(NEW_LINE).append(NEW_LINE);
            return sb.toString().getBytes(StandardCharsets.UTF_8);
        }
    }
}

