/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct.http;

import develop.toolkit.base.struct.http.ByteRequestBody;
import develop.toolkit.base.struct.http.FormUrlencodedBody;
import develop.toolkit.base.struct.http.HttpRequestBody;
import develop.toolkit.base.struct.http.MultiPartFormDataBody;
import develop.toolkit.base.struct.http.RawRequestBody;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

@FunctionalInterface
public interface SenderHandler<BODY> {
    default public HttpRequest.BodyPublisher bodyPublisher(HttpRequestBody<?> requestBody) {
        if (requestBody == null) {
            return HttpRequest.BodyPublishers.noBody();
        }
        if (requestBody instanceof RawRequestBody) {
            return HttpRequest.BodyPublishers.ofString(((RawRequestBody)requestBody).getBody());
        }
        if (requestBody instanceof FormUrlencodedBody) {
            return HttpRequest.BodyPublishers.ofString(((FormUrlencodedBody)requestBody).getBody());
        }
        if (requestBody instanceof ByteRequestBody) {
            return HttpRequest.BodyPublishers.ofByteArray(((ByteRequestBody)requestBody).getBody());
        }
        if (requestBody instanceof MultiPartFormDataBody) {
            return HttpRequest.BodyPublishers.ofByteArray(((MultiPartFormDataBody)requestBody).getBody());
        }
        throw new AssertionError();
    }

    public HttpResponse.BodyHandler<BODY> bodyHandler();
}

