/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.struct.ZipWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class CompressAdvice {

    public static class Zip {
        public static void compress(final Path path, OutputStream outputStream) throws IOException {
            try (final ZipOutputStream zos = new ZipOutputStream(outputStream);){
                Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                        String currentName = filePath.subpath(path.getNameCount(), filePath.getNameCount()).toString();
                        File file = filePath.toFile();
                        ZipEntry zipEntry = new ZipEntry(currentName);
                        zipEntry.setMethod(currentName.endsWith(".zip") ? 0 : 8);
                        zipEntry.setLastModifiedTime(FileTime.fromMillis(file.lastModified()));
                        zos.putNextEntry(zipEntry);
                        try (FileInputStream is = new FileInputStream(file);){
                            ((InputStream)is).transferTo(zos);
                        }
                        zos.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }

        public static byte[] compress(Path path) throws IOException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Zip.compress(path, (OutputStream)baos);
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }

        public static void compress(Path path, Path outPath) throws IOException {
            try (FileOutputStream os = new FileOutputStream(outPath.toFile());){
                Zip.compress(path, (OutputStream)os);
            }
        }

        public static void compress(ZipWrapper zipWrapper, OutputStream outputStream) throws IOException {
            try (ZipOutputStream zos = new ZipOutputStream(outputStream);){
                Zip.recursiveCompress(zipWrapper, "", zos);
            }
        }

        private static void recursiveCompress(ZipWrapper zipWrapper, String parentPath, ZipOutputStream zos) throws IOException {
            String currentName = parentPath + zipWrapper.getFilename();
            if (zipWrapper.isFile()) {
                ZipEntry zipEntry = new ZipEntry(currentName);
                zipWrapper.configureZipEntry(zipEntry);
                zos.putNextEntry(zipEntry);
                try (InputStream is = zipWrapper.getInputStreamSupplier().get();){
                    is.transferTo(zos);
                }
                zos.closeEntry();
            } else {
                List<ZipWrapper> children = zipWrapper.getChildren();
                if (children != null) {
                    for (ZipWrapper childZipWrapper : children) {
                        Zip.recursiveCompress(childZipWrapper, currentName + File.separator, zos);
                    }
                }
            }
        }
    }

    public static class GZip {
        public static void compress(InputStream inputStream, OutputStream outputStream) throws IOException {
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
                inputStream.transferTo(gzipOutputStream);
            }
        }

        public static void compress(byte[] data, OutputStream outputStream) throws IOException {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
                GZip.compress(bais, outputStream);
            }
        }

        public static byte[] compress(InputStream inputStream) throws IOException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                GZip.compress(inputStream, (OutputStream)baos);
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }

        public static byte[] compress(byte[] data) throws IOException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                GZip.compress(data, (OutputStream)baos);
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }

        public static void uncompress(InputStream inputStream, OutputStream outputStream) throws IOException {
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
                gzipInputStream.transferTo(outputStream);
            }
        }

        public static void uncompress(byte[] data, OutputStream outputStream) throws IOException {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
                GZip.uncompress(bais, outputStream);
            }
        }

        public static byte[] uncompress(InputStream inputStream) throws IOException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                GZip.uncompress(inputStream, (OutputStream)baos);
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }

        public static byte[] uncompress(byte[] data) throws IOException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                GZip.uncompress(data, (OutputStream)baos);
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }
    }
}

