/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.exception.CryptException;
import develop.toolkit.base.struct.TwoValues;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;

public abstract class CryptAdvice {

    public static class RSA {
        private static final String KEY_ALGORITHM = "RSA";
        private static final int KEY_SIZE = 1024;
        private static final String SIGNATURE_ALGORITHM = "Sha1WithRSA";

        public static TwoValues<String, String> createRSAKeys() {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGenerator.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            Base64.Encoder encoder = Base64.getEncoder();
            return TwoValues.of(encoder.encodeToString(publicKey.getEncoded()), encoder.encodeToString(privateKey.getEncoded()));
        }

        public static String encrypt(String original, String publicKeyBase64) throws CryptException {
            try {
                byte[] publicKeyBytes = Base64.getDecoder().decode(publicKeyBase64);
                RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
                Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
                cipher.init(1, pubKey);
                byte[] bytes = original.getBytes(StandardCharsets.UTF_8);
                int offset = 64;
                byte[] enBytes = null;
                for (int i = 0; i < bytes.length; i += 64) {
                    byte[] doFinal = cipher.doFinal(ArrayUtils.subarray((byte[])bytes, (int)i, (int)(i + 64)));
                    enBytes = ArrayUtils.addAll(enBytes, (byte[])doFinal);
                }
                return Base64.getEncoder().encodeToString(enBytes);
            }
            catch (Exception e) {
                throw new CryptException(e);
            }
        }

        public static String decrypt(String ciphertext, String privateKeyBase64) throws CryptException {
            try {
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] privateKeyBytes = decoder.decode(privateKeyBase64);
                PrivateKey privateKey = KeyFactory.getInstance(KEY_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
                Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
                cipher.init(2, privateKey);
                byte[] inputBytes = decoder.decode(ciphertext.getBytes(StandardCharsets.UTF_8));
                StringBuilder sb = new StringBuilder();
                int offset = 128;
                for (int i = 0; i < inputBytes.length; i += 128) {
                    byte[] doFinal = cipher.doFinal(ArrayUtils.subarray((byte[])inputBytes, (int)i, (int)(i + 128)));
                    sb.append(new String(doFinal));
                }
                return sb.toString();
            }
            catch (Exception e) {
                throw new CryptException(e);
            }
        }

        public static String signature(byte[] data, String privateKeyBase64) {
            try {
                byte[] privateKeyBytes = Base64.getDecoder().decode(privateKeyBase64);
                Signature sign = Signature.getInstance(SIGNATURE_ALGORITHM);
                PrivateKey privateKey = KeyFactory.getInstance(KEY_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
                sign.initSign(privateKey);
                sign.update(data);
                return Base64.getEncoder().encodeToString(sign.sign());
            }
            catch (Exception e) {
                throw new CryptException(e);
            }
        }

        public static boolean verifySignature(byte[] data, String signatureBase64, String publicKeyBase64) {
            try {
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] publicKeyBytes = decoder.decode(publicKeyBase64);
                byte[] signatureBytes = decoder.decode(signatureBase64);
                RSAPublicKey publicKey = (RSAPublicKey)KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
                Signature sign = Signature.getInstance(SIGNATURE_ALGORITHM);
                sign.initVerify(publicKey);
                sign.update(data);
                return sign.verify(signatureBytes);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class AES {
        private static final String ALGORITHM = "AES";
        private static final String SECRET_KEY_ALGORITHM = "PBKDF2WithHmacSHA256";

        public static TwoValues<String, String> createSecretKeyAndIv(KeyLength keyLength) {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
            keyGenerator.init(keyLength.getLength());
            byte[] iv = new byte[16];
            new SecureRandom().nextBytes(iv);
            Base64.Encoder encoder = Base64.getEncoder();
            return TwoValues.of(encoder.encodeToString(keyGenerator.generateKey().getEncoded()), encoder.encodeToString(iv));
        }

        public static TwoValues<String, String> createSecretKeyAndIvByPassword(KeyLength keyLength, String password, String salt) {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(SECRET_KEY_ALGORITHM);
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 65536, keyLength.getLength());
            SecretKeySpec secretKeySpec = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), ALGORITHM);
            byte[] iv = new byte[16];
            new SecureRandom().nextBytes(iv);
            Base64.Encoder encoder = Base64.getEncoder();
            return TwoValues.of(encoder.encodeToString(secretKeySpec.getEncoded()), encoder.encodeToString(iv));
        }

        public static String encrypt(String original, String secretKeyBase64, String ivBase64) throws CryptException {
            try {
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] secretKey = decoder.decode(secretKeyBase64);
                byte[] iv = decoder.decode(ivBase64);
                SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, SECRET_KEY_ALGORITHM);
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(iv));
                byte[] cipherText = cipher.doFinal(original.getBytes(StandardCharsets.UTF_8));
                return Base64.getEncoder().encodeToString(cipherText);
            }
            catch (Exception e) {
                throw new CryptException(e);
            }
        }

        public static String decrypt(String cipherText, String secretKeyBase64, String ivBase64) throws CryptException {
            try {
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] secretKey = decoder.decode(secretKeyBase64);
                byte[] iv = decoder.decode(ivBase64);
                SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, SECRET_KEY_ALGORITHM);
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(iv));
                byte[] plainText = cipher.doFinal(Base64.getDecoder().decode(cipherText));
                return new String(plainText, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new CryptException(e);
            }
        }

        public static enum KeyLength {
            KEY_LENGTH_128(128),
            KEY_LENGTH_192(192),
            KEY_LENGTH_256(256);

            private final int length;

            private KeyLength(int length) {
                this.length = length;
            }

            public int getLength() {
                return this.length;
            }
        }
    }

    public static class DES {
        public static String encrypt(String original, String secretKey) {
            try {
                Cipher cipher = DES.initCipher(secretKey, 1);
                byte[] data = cipher.doFinal(original.getBytes(StandardCharsets.UTF_8));
                return Base64.getEncoder().encodeToString(data);
            }
            catch (Exception e) {
                throw new CryptException(e);
            }
        }

        public static String decrypt(String ciphertext, String secretKey) throws CryptException {
            try {
                byte[] data = Base64.getDecoder().decode(ciphertext);
                Cipher cipher = DES.initCipher(secretKey, 2);
                return new String(cipher.doFinal(data), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new CryptException(e);
            }
        }

        private static Cipher initCipher(String secretKey, int mode) throws Exception {
            DESKeySpec dks = new DESKeySpec(secretKey.getBytes(StandardCharsets.UTF_8));
            SecretKey secureKey = SecretKeyFactory.getInstance("DES").generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(mode, (Key)secureKey, new SecureRandom());
            return cipher;
        }
    }
}

