/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public abstract class FileAdvice {
    public static void write(Path filePath, CharSequence text, Charset charset, boolean append) {
        try {
            FileAdvice.touch(filePath);
            Files.writeString(filePath, text, charset, StandardOpenOption.WRITE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(Path filePath, Iterable<? extends CharSequence> lines, Charset charset, boolean append) {
        try {
            FileAdvice.touch(filePath);
            Files.write(filePath, lines, charset, StandardOpenOption.WRITE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void touch(Path path) throws IOException {
        Path parent = path.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    public static List<Path> files(final Path path, final Predicate<Path> predicate) {
        final LinkedList paths = new LinkedList();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (predicate.test(file)) {
                        paths.add(path);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
            return Collections.unmodifiableList(paths);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static long sliceBytes(int bufferSize, long offset, long chunkSize, File file, OutputStream out) throws IOException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            long transferred;
            int read;
            randomAccessFile.seek(offset);
            byte[] buffer = new byte[bufferSize];
            for (transferred = 0L; transferred < chunkSize && (read = randomAccessFile.read(buffer, 0, (int)Math.min((long)buffer.length, chunkSize - transferred))) != -1; transferred += (long)read) {
                out.write(buffer, 0, read);
            }
            long l = transferred;
            return l;
        }
    }
}

