/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.EmptyExpression;
import com.github.developframework.expression.Expression;
import develop.toolkit.base.constants.DateFormatConstants;
import develop.toolkit.base.struct.KeyValuePair;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public final class JacksonAdvice {
    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS});
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateFormatConstants.STANDARD_FORMATTER));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateFormatConstants.STANDARD_FORMATTER));
        objectMapper.registerModule((Module)javaTimeModule);
        return objectMapper;
    }

    public static XmlMapper defaultXmlMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        xmlMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        xmlMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS});
        xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        xmlMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateFormatConstants.STANDARD_FORMATTER));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateFormatConstants.STANDARD_FORMATTER));
        xmlMapper.registerModule((Module)javaTimeModule);
        return xmlMapper;
    }

    public static String serializeQuietly(ObjectMapper objectMapper, Object object, boolean pretty) {
        if (pretty) {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        return objectMapper.writeValueAsString(object);
    }

    public static JsonNode deserializeTreeQuietly(ObjectMapper objectMapper, String json) {
        return objectMapper.readTree(json);
    }

    public static <T> T treeToValueQuietly(ObjectMapper objectMapper, TreeNode node, Class<T> clazz) {
        return (T)objectMapper.treeToValue(node, clazz);
    }

    public static <T> T deserializeQuietly(ObjectMapper objectMapper, String json, Class<T> clazz) {
        return (T)objectMapper.readValue(json, clazz);
    }

    public static <T> T[] deserializeArrayQuietly(ObjectMapper objectMapper, String json, Class<T> clazz) {
        return (Object[])objectMapper.readValue(json, (JavaType)objectMapper.getTypeFactory().constructArrayType(clazz));
    }

    public static <T extends Collection<E>, E> T deserializeCollectionQuietly(ObjectMapper objectMapper, String json, Class<T> collectionClass, Class<E> itemClass) {
        return (T)((Collection)objectMapper.readValue(json, (JavaType)objectMapper.getTypeFactory().constructCollectionType(collectionClass, itemClass)));
    }

    public static <T> T deserializeValue(ObjectMapper objectMapper, JsonNode rootNode, String expressionValue, Class<T> clazz) {
        return (T)objectMapper.treeToValue((TreeNode)JacksonAdvice.parseExpressionToJsonNode(rootNode, Expression.parse((String)expressionValue)), clazz);
    }

    public static <T> T[] deserializeArray(ObjectMapper objectMapper, JsonNode rootNode, String expressionValue, Class<T> clazz) {
        JsonNode jsonNode = JacksonAdvice.parseExpressionToJsonNode(rootNode, Expression.parse((String)expressionValue));
        if (!jsonNode.isArray()) {
            throw new IllegalArgumentException("\"" + expressionValue + "\" value is not a array.");
        }
        return (Object[])objectMapper.readValue(jsonNode.toString(), (JavaType)objectMapper.getTypeFactory().constructArrayType(clazz));
    }

    public static <T> List<T> deserializeList(ObjectMapper objectMapper, JsonNode rootNode, String expressionValue, Class<T> clazz) {
        JsonNode jsonNode = JacksonAdvice.parseExpressionToJsonNode(rootNode, Expression.parse((String)expressionValue));
        if (!jsonNode.isArray()) {
            throw new IllegalArgumentException("\"" + expressionValue + "\" value is not a list.");
        }
        return (List)objectMapper.readValue(jsonNode.toString(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, clazz));
    }

    @SafeVarargs
    public static Object[] deserializeValues(ObjectMapper objectMapper, JsonNode rootNode, KeyValuePair<String, Class<?>> ... expressionValues) {
        Object[] values = new Object[expressionValues.length];
        for (int i = 0; i < expressionValues.length; ++i) {
            KeyValuePair<String, Class<?>> kv = expressionValues[i];
            Expression expression = Expression.parse((String)kv.getKey());
            JsonNode jsonNode = JacksonAdvice.parseExpressionToJsonNode(rootNode, expression);
            values[i] = objectMapper.treeToValue((TreeNode)jsonNode, kv.getValue());
        }
        return values;
    }

    public static <T> List<T> arrayNodeToList(ArrayNode arrayNode, Function<JsonNode, T> function) {
        ArrayList<T> list = new ArrayList<T>(arrayNode.size());
        for (JsonNode node : arrayNode) {
            list.add(function.apply(node));
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> T[] arrayNodeToArray(ArrayNode arrayNode, Class<T> clazz, Function<JsonNode, T> function) {
        Object[] array = (Object[])Array.newInstance(clazz, arrayNode.size());
        int i = 0;
        for (JsonNode node : arrayNode) {
            array[i++] = function.apply(node);
        }
        return array;
    }

    private static JsonNode parseExpressionToJsonNode(JsonNode jsonNode, Expression expression) {
        if (expression != EmptyExpression.INSTANCE) {
            for (Expression singleExpression : expression.expressionTree()) {
                if (singleExpression.isObject()) {
                    jsonNode = JacksonAdvice.existsJsonNode(jsonNode, singleExpression.getName());
                    continue;
                }
                if (singleExpression.isArray()) {
                    ArrayExpression ae = (ArrayExpression)singleExpression;
                    jsonNode = JacksonAdvice.existsJsonNode(jsonNode, ae.getName());
                    for (int i : ae.getIndexArray()) {
                        if (!jsonNode.isArray()) {
                            throw new IllegalArgumentException("jsonNode is not Array,for expression:" + singleExpression);
                        }
                        jsonNode = jsonNode.get(i);
                    }
                    continue;
                }
                if (!singleExpression.isMethod()) continue;
                throw new IllegalArgumentException("not support method expression.");
            }
        }
        return jsonNode;
    }

    private static JsonNode existsJsonNode(JsonNode parentNode, String propertyName) {
        if (propertyName.isEmpty() && parentNode.isArray()) {
            return parentNode;
        }
        JsonNode node = parentNode.get(propertyName);
        if (node == null) {
            throw new IllegalArgumentException("Not found node \"" + propertyName + "\"");
        }
        return node;
    }
}

