/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class MathAdvice {
    public static double max(Collection<Number> numbers) {
        return numbers.stream().mapToDouble(Number::doubleValue).max().orElseThrow();
    }

    public static double min(Collection<Number> numbers) {
        return numbers.stream().mapToDouble(Number::doubleValue).min().orElseThrow();
    }

    public static double average(Collection<Number> numbers) {
        return numbers.stream().mapToDouble(Number::doubleValue).average().orElseThrow();
    }

    public static double variance(Collection<Number> numbers) {
        double average = MathAdvice.average(numbers);
        return numbers.stream().mapToDouble(number -> Math.pow(number.doubleValue() - average, 2.0)).average().orElseThrow();
    }

    public static double standardDeviation(Collection<Number> numbers) {
        return Math.sqrt(MathAdvice.variance(numbers));
    }

    public static double median(Collection<Number> numbers) {
        List list = numbers.stream().sorted().map(Number::doubleValue).collect(Collectors.toList());
        if (list.size() % 2 == 0) {
            int half = list.size() / 2;
            return ((Double)list.get(half) + (Double)list.get(half + 1)) / 2.0;
        }
        return (Double)list.get(list.size() / 2 + 1);
    }
}

