/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.db.mysql;

import develop.toolkit.base.utils.IOAdvice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SQLFactory {
    private Map<String, String> sqlMap = new HashMap<String, String>();

    public SQLFactory(String ... sqlFiles) {
        for (String sqlFile : sqlFiles) {
            this.parseSqlFile(sqlFile);
        }
    }

    private void parseSqlFile(String sqlFile) {
        List lines = IOAdvice.readLinesFromClasspath((String)sqlFile).collect(Collectors.toList());
        String key = null;
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (line.isBlank()) continue;
            if (line.startsWith("#")) {
                this.putSql(key, sb);
                key = line.substring(1).trim();
                continue;
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(line.trim());
        }
        this.putSql(key, sb);
    }

    private void putSql(String key, StringBuilder sb) {
        if (key != null && sb.length() > 0) {
            if (this.sqlMap.containsKey(key)) {
                throw new RuntimeException("sql map exists \"" + key + "\"");
            }
            this.sqlMap.put(key, sb.toString());
            sb.setLength(0);
        }
    }

    public String getSql(String key) {
        String sql = this.sqlMap.get(key);
        if (sql == null) {
            throw new RuntimeException("sql map not exists \"" + key + "\"");
        }
        return sql;
    }
}

