/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.support.mongo.utils;

import develop.toolkit.support.mongo.utils.AggregationOperationUtils;
import develop.toolkit.support.mongo.utils.JoinType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class AggregationOperationBuilder {
    private static final String REF_SUFFIX = "Id";
    private List<AggregationOperation> aggregationOperations;

    public AggregationOperationBuilder() {
        this.aggregationOperations = new LinkedList<AggregationOperation>();
    }

    public AggregationOperationBuilder(List<AggregationOperation> aggregationOperations) {
        this.aggregationOperations = new LinkedList<AggregationOperation>(aggregationOperations);
    }

    public List<AggregationOperation> build() {
        return this.aggregationOperations;
    }

    public AggregationOperationBuilder merge(List<AggregationOperation> otherAggregationOperations) {
        this.aggregationOperations.addAll(otherAggregationOperations);
        return this;
    }

    public AggregationOperationBuilder join(String localField, String lookupAs, Class<?> foreignDocClass, JoinType joinType, boolean preserveNullAndEmptyArrays) {
        String from = AggregationOperationUtils.collectionNameFormDocumentAnnotation(foreignDocClass);
        return this.join(localField, lookupAs, from, joinType, preserveNullAndEmptyArrays);
    }

    public AggregationOperationBuilder join(String localField, String lookupAs, String from, JoinType joinType, boolean preserveNullAndEmptyArrays) {
        String localFieldId = localField + REF_SUFFIX;
        this.aggregationOperations.add(AggregationOperationUtils.addRefFields(localFieldId, localField, joinType));
        return this.lookupAndUnwind(from, localFieldId, lookupAs, preserveNullAndEmptyArrays);
    }

    public AggregationOperationBuilder lookupAndUnwind(String from, String localField, String lookupAs, boolean preserveNullAndEmptyArrays) {
        this.aggregationOperations.add((AggregationOperation)Aggregation.lookup((String)from, (String)localField, (String)"_id", (String)lookupAs));
        this.aggregationOperations.add((AggregationOperation)Aggregation.unwind((String)lookupAs, (boolean)preserveNullAndEmptyArrays));
        return this;
    }

    public AggregationOperationBuilder match(Query query) {
        this.aggregationOperations.add(context -> new Document("$match", (Object)query.getQueryObject()));
        return this;
    }

    public AggregationOperationBuilder match(Criteria criteria) {
        this.aggregationOperations.add((AggregationOperation)Aggregation.match((Criteria)criteria));
        return this;
    }

    public AggregationOperationBuilder addFields(String ... expressions) {
        this.aggregationOperations.add(AggregationOperationUtils.addFields(expressions));
        return this;
    }

    public AggregationOperationBuilder project(String ... fields) {
        this.aggregationOperations.add(AggregationOperationUtils.project(fields));
        return this;
    }

    public AggregationOperationBuilder complex(AggregationOperation ... aggregationOperations) {
        this.aggregationOperations.addAll(Arrays.asList(aggregationOperations));
        return this;
    }

    public AggregationOperationBuilder aggregation(AggregationOperation aggregationOperation) {
        this.aggregationOperations.add(aggregationOperation);
        return this;
    }

    public AggregationOperationBuilder unwind(String field, boolean preserveNullAndEmptyArrays) {
        this.aggregationOperations.add((AggregationOperation)Aggregation.unwind((String)field, (boolean)preserveNullAndEmptyArrays));
        return this;
    }

    public AggregationOperationBuilder json(String json) {
        this.aggregationOperations.add(context -> Document.parse((String)json));
        return this;
    }

    public AggregationOperationBuilder distinct(String ... fields) {
        String[] stringArray;
        String key = "uniqueValue";
        if (fields.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "$_id";
        } else {
            stringArray = fields;
        }
        this.aggregationOperations.add((AggregationOperation)Aggregation.group((String[])stringArray).addToSet("$$ROOT").as("uniqueValue"));
        this.aggregationOperations.add((AggregationOperation)Aggregation.unwind((String)"uniqueValue"));
        this.aggregationOperations.add((AggregationOperation)Aggregation.replaceRoot((String)"uniqueValue"));
        return this;
    }

    public AggregationOperationBuilder count(String field) {
        this.aggregationOperations.add((AggregationOperation)Aggregation.group((String[])new String[0]).count().as(field));
        return this;
    }
}

