/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.support.mongo.utils;

import com.mongodb.BasicDBObject;
import develop.toolkit.support.mongo.utils.JoinType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.bson.BasicBSONObject;
import org.bson.Document;
import org.bson.types.BasicBSONList;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.query.Query;

public final class AggregationOperationUtils {
    public static AggregationOperation addRefFields(String newFieldName, String sourceFieldName, JoinType joinType) {
        return joinType == JoinType.OBJECT ? AggregationOperationUtils.addRefFieldsForObject(newFieldName, sourceFieldName) : AggregationOperationUtils.addRefFieldsForArray(newFieldName, sourceFieldName);
    }

    private static AggregationOperation addRefFieldsForArray(String newFieldName, String sourceFieldName) {
        return context -> {
            BasicBSONList inList = new BasicBSONList();
            inList.add((Object)new BasicBSONObject("$objectToArray", (Object)"$$this"));
            inList.add((Object)1);
            BasicBSONObject addFields = new BasicBSONObject("$addFields", (Object)new BasicBSONObject(newFieldName, (Object)new BasicBSONObject("$map", (Object)new BasicBSONObject("input", (Object)new BasicBSONObject("$map", (Object)new BasicBSONObject("input", (Object)("$" + sourceFieldName)).append("in", (Object)new BasicDBObject("$arrayElemAt", (Object)inList)))).append("in", (Object)"$$this.v"))));
            return new Document(addFields.toMap());
        };
    }

    private static AggregationOperation addRefFieldsForObject(String newFieldName, String sourceFieldName) {
        return context -> {
            BasicBSONList inList = new BasicBSONList();
            inList.add((Object)new BasicBSONObject("$objectToArray", (Object)("$" + sourceFieldName)));
            inList.add((Object)1);
            BasicBSONObject addFields = new BasicBSONObject("$addFields", (Object)new BasicBSONObject(newFieldName, (Object)new BasicDBObject("$let", (Object)new BasicBSONObject("vars", (Object)new BasicDBObject("myVar", (Object)new BasicDBObject("$arrayElemAt", (Object)inList))).append("in", (Object)"$$myVar.v"))));
            return new Document(addFields.toMap());
        };
    }

    public static AggregationOperation matchForQuery(Query query) {
        return context -> new Document("$match", (Object)query.getQueryObject());
    }

    @Deprecated
    public static AggregationOperation groupCount() {
        return context -> new Document("$group", (Object)new Document("_id", null).append("count", (Object)new Document("$sum", (Object)1)));
    }

    public static AggregationOperation addFields(String ... expressions) {
        return context -> {
            Document document = new Document();
            for (String expression : expressions) {
                String[] parts = expression.split(":");
                if (parts.length == 1) {
                    throw new IllegalArgumentException();
                }
                document.put(parts[0].trim(), (Object)parts[1].trim());
            }
            return new Document("$addFields", (Object)document);
        };
    }

    public static AggregationOperation project(String ... fieldStrs) {
        Field[] fields = (Field[])Stream.of(fieldStrs).map(field -> {
            String[] parts = field.split(":");
            return parts.length == 1 ? Fields.field((String)parts[0]) : Fields.field((String)parts[0].trim(), (String)parts[1].trim());
        }).toArray(Field[]::new);
        return Aggregation.project((Fields)Fields.from((Field[])fields));
    }

    public static List<AggregationOperation> aggregationOperations(AggregationOperation ... aggregationOperations) {
        return new LinkedList<AggregationOperation>(Arrays.asList(aggregationOperations));
    }

    protected static String collectionNameFormDocumentAnnotation(Class<?> docClass) {
        String collectionName;
        org.springframework.data.mongodb.core.mapping.Document annotation = (org.springframework.data.mongodb.core.mapping.Document)AnnotationUtils.findAnnotation(docClass, org.springframework.data.mongodb.core.mapping.Document.class);
        if (annotation != null && StringUtils.isNotBlank((CharSequence)(collectionName = annotation.collection()))) {
            return collectionName;
        }
        throw new IllegalStateException();
    }
}

