/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.support.mongo.utils;

import develop.toolkit.support.mongo.utils.AggregationOperationUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.repository.support.PageableExecutionUtils;

public final class AggregationQueryHelper {
    public static <T> Optional<T> aggregationOne(MongoOperations mongoOperations, List<AggregationOperation> aggregationOperations, String collectionName, Class<T> outputClass) {
        List<T> list = AggregationQueryHelper.aggregationList(mongoOperations, aggregationOperations, collectionName, outputClass);
        return Optional.ofNullable(list.isEmpty() ? null : (Object)list.get(0));
    }

    public static <T> Optional<T> aggregationOne(MongoOperations mongoOperations, List<AggregationOperation> aggregationOperations, Class<?> docClass, Class<T> outputClass) {
        List<T> list = AggregationQueryHelper.aggregationList(mongoOperations, aggregationOperations, docClass, outputClass);
        return Optional.ofNullable(list.isEmpty() ? null : (Object)list.get(0));
    }

    public static <T> Optional<T> aggregationOne(MongoOperations mongoOperations, List<AggregationOperation> aggregationOperations, Class<T> clazz) {
        return AggregationQueryHelper.aggregationOne(mongoOperations, aggregationOperations, clazz, clazz);
    }

    public static <T> List<T> aggregationList(MongoOperations mongoOperations, List<AggregationOperation> aggregationOperations, String collectionName, Class<T> outputClass) {
        return mongoOperations.aggregate(Aggregation.newAggregation(aggregationOperations), collectionName, outputClass).getMappedResults();
    }

    public static <T> List<T> aggregationList(MongoOperations mongoOperations, List<AggregationOperation> aggregationOperations, Class<?> docClass, Class<T> outputClass) {
        String collectionName = AggregationOperationUtils.collectionNameFormDocumentAnnotation(docClass);
        return AggregationQueryHelper.aggregationList(mongoOperations, aggregationOperations, collectionName, outputClass);
    }

    public static <T> List<T> aggregationList(MongoOperations mongoOperations, List<AggregationOperation> aggregationOperations, Class<T> clazz) {
        return AggregationQueryHelper.aggregationList(mongoOperations, aggregationOperations, clazz, clazz);
    }

    public static <T> Page<T> aggregationPager(MongoOperations mongoOperations, Pageable pageable, List<AggregationOperation> aggregationOperations, String collectionName, Class<T> outputClass) {
        LinkedList<AggregationOperation> queryCountAggregationOperation = new LinkedList<AggregationOperation>(aggregationOperations);
        queryCountAggregationOperation.add((AggregationOperation)Aggregation.count().as("count"));
        AggregationResults countResults = mongoOperations.aggregate(Aggregation.newAggregation(queryCountAggregationOperation), collectionName, Map.class);
        LinkedList<AggregationOperation> queryListAggregationOperation = new LinkedList<AggregationOperation>(aggregationOperations);
        queryListAggregationOperation.add(context -> Aggregation.sort((Sort)pageable.getSort()).toDocument(Aggregation.DEFAULT_CONTEXT));
        queryListAggregationOperation.add((AggregationOperation)Aggregation.skip((long)pageable.getOffset()));
        queryListAggregationOperation.add((AggregationOperation)Aggregation.limit((long)pageable.getPageSize()));
        AggregationResults results = mongoOperations.aggregate(Aggregation.newAggregation(queryListAggregationOperation), collectionName, outputClass);
        return PageableExecutionUtils.getPage((List)results.getMappedResults(), (Pageable)pageable, () -> {
            Map uniqueMappedResult = (Map)countResults.getUniqueMappedResult();
            return uniqueMappedResult == null ? 0L : (long)((Integer)uniqueMappedResult.get("count")).intValue();
        });
    }

    public static <T> Page<T> aggregationPager(MongoOperations mongoOperations, Pageable pageable, List<AggregationOperation> aggregationOperations, Class<?> docClass, Class<T> outputClass) {
        String collectionName = AggregationOperationUtils.collectionNameFormDocumentAnnotation(docClass);
        return AggregationQueryHelper.aggregationPager(mongoOperations, pageable, aggregationOperations, collectionName, outputClass);
    }

    public static <T> Page<T> aggregationPager(MongoOperations mongoOperations, Pageable pageable, List<AggregationOperation> aggregationOperations, Class<T> clazz) {
        String collectionName = AggregationOperationUtils.collectionNameFormDocumentAnnotation(clazz);
        return AggregationQueryHelper.aggregationPager(mongoOperations, pageable, aggregationOperations, collectionName, clazz);
    }

    public static int aggregationCount(MongoOperations mongoOperations, List<AggregationOperation> aggregationOperations, String collectionName, String countField) {
        return AggregationQueryHelper.aggregationOne(mongoOperations, aggregationOperations, collectionName, Map.class).map(map -> (Integer)map.get(countField)).orElse(0);
    }

    public static int aggregationCount(MongoOperations mongoOperations, List<AggregationOperation> aggregationOperations, Class<?> docClass, String countField) {
        String collectionName = AggregationOperationUtils.collectionNameFormDocumentAnnotation(docClass);
        return AggregationQueryHelper.aggregationCount(mongoOperations, aggregationOperations, collectionName, countField);
    }
}

