/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.support.mongo.utils;

import develop.toolkit.support.mongo.utils.Querys;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public final class QueryBuilder {
    private Query query;

    public QueryBuilder() {
        this.query = new Query();
    }

    public QueryBuilder(Query query) {
        this.query = query;
    }

    public Query build() {
        return this.query;
    }

    public QueryBuilder id(String attribute, String id) {
        if (id != null) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).is((Object)new ObjectId(id)));
        }
        return this;
    }

    public QueryBuilder equal(String attribute, Object value) {
        if (value != null) {
            if (value instanceof String && ((String)value).isEmpty()) {
                return this;
            }
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).is(value));
        }
        return this;
    }

    public QueryBuilder notEqual(String attribute, Object value) {
        if (value != null) {
            if (value instanceof String && ((String)value).isEmpty()) {
                return this;
            }
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).ne(value));
        }
        return this;
    }

    public QueryBuilder containsLike(String attribute, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).regex("^.*" + Querys.escapeRegex(value) + ".*$"));
        }
        return this;
    }

    public QueryBuilder startWith(String attribute, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).regex("^" + Querys.escapeRegex(value) + ".*$"));
        }
        return this;
    }

    public QueryBuilder endWith(String attribute, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).regex("^.*" + Querys.escapeRegex(value) + "$"));
        }
        return this;
    }

    public <Y extends Comparable<? super Y>> QueryBuilder isBetween(String attribute, Y min, Y max) {
        if (min != null) {
            Criteria criteria = Criteria.where((String)attribute).gte(min);
            if (max != null) {
                criteria = criteria.lte(max);
            }
            this.query.addCriteria((CriteriaDefinition)criteria);
        } else if (max != null) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).lte(max));
        }
        return this;
    }

    public <E> QueryBuilder in(String attribute, Collection<E> collection) {
        if (collection != null && !collection.isEmpty()) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).in(collection));
        }
        return this;
    }

    public <E> QueryBuilder in(String attribute, E ... array) {
        return this.in(attribute, array != null ? Arrays.asList(array) : null);
    }

    public <Y extends Comparable<? super Y>> QueryBuilder greaterThan(String attribute, Y value) {
        if (value != null) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).gt(value));
        }
        return this;
    }

    public <Y extends Comparable<? super Y>> QueryBuilder greaterThanOrEqualTo(String attribute, Y value) {
        if (value != null) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).gte(value));
        }
        return this;
    }

    public <Y extends Comparable<? super Y>> QueryBuilder lessThan(String attribute, Y value) {
        if (value != null) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).lt(value));
        }
        return this;
    }

    public <Y extends Comparable<? super Y>> QueryBuilder lessThanOrEqualTo(String attribute, Y value) {
        if (value != null) {
            this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).lte(value));
        }
        return this;
    }

    public QueryBuilder exists(String attribute, boolean exists) {
        this.query.addCriteria((CriteriaDefinition)Criteria.where((String)attribute).exists(exists));
        return this;
    }

    public QueryBuilder complexQuery(ComplexQuery complexQuery) {
        complexQuery.complex(this.query);
        return this;
    }

    public static interface ComplexQuery {
        public void complex(Query var1);
    }
}

