/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.support.mongo.utils;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;

public final class Querys {
    public static Query id(String field, String id) {
        return Querys.is(field, new ObjectId(id));
    }

    public static Query is(String field, @Nullable Object value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).is(value));
    }

    public static Query ne(String field, @Nullable Object value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).ne(value));
    }

    public static Query gt(String field, Object value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).gt(value));
    }

    public static Query gte(String field, Object value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).gte(value));
    }

    public static Query lt(String field, Object value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).lt(value));
    }

    public static Query lte(String field, @Nullable Object value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).lte(value));
    }

    public static Query regex(String field, String keyword) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).regex(Querys.escapeRegex(keyword)));
    }

    public static Query in(String field, Object ... value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).in(value));
    }

    public static Query in(String field, Collection<?> collection) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).in(collection));
    }

    public static Query nin(String field, Object ... value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).nin(value));
    }

    public static Query nin(String field, Collection<?> collection) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).nin(collection));
    }

    public static Query exists(String field, boolean value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).exists(value));
    }

    public static Query type(String field, int value) {
        return new Query().addCriteria((CriteriaDefinition)Criteria.where((String)field).type(value));
    }

    public static String escapeRegex(String keyword) {
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }
}

