/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.expression;

import com.github.developframework.expression.Expression;
import lombok.NonNull;

public class ObjectExpression
extends Expression {
    private String propertyName;

    public ObjectExpression(@NonNull String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked @NonNull but is null");
        }
        this.propertyName = propertyName;
    }

    public String toString() {
        if (this.parentExpression == Expression.EMPTY_EXPRESSION) {
            return this.propertyName;
        }
        return this.parentExpression + "." + this.propertyName;
    }

    public int hashCode() {
        int hash = 7;
        if (this.hasParentExpression()) {
            hash = hash * 31 + this.parentExpression.hashCode();
        }
        hash = hash * 31 + this.propertyName.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        ObjectExpression otherExpression;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ObjectExpression && this.propertyName.equals((otherExpression = (ObjectExpression)obj).getPropertyName())) {
            return this.parentExpression.equals(otherExpression.getParentExpression());
        }
        return false;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

