/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.jaxrs.JerseyInvocationBuilder;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

class JerseyWebTarget
implements WebTarget {
    private static final String PATH_SEPARATOR = "/";
    private final ObjectMapper objectMapper;
    private final javax.ws.rs.client.WebTarget webTarget;

    JerseyWebTarget(ObjectMapper objectMapper, javax.ws.rs.client.WebTarget webTarget) {
        this.objectMapper = objectMapper;
        this.webTarget = webTarget;
    }

    public InvocationBuilder request() {
        return new JerseyInvocationBuilder(this.objectMapper, this.webTarget.request());
    }

    public JerseyWebTarget path(String ... components) {
        return new JerseyWebTarget(this.objectMapper, this.webTarget.path(String.join((CharSequence)PATH_SEPARATOR, components)));
    }

    public JerseyWebTarget resolveTemplate(String name, Object value) {
        return new JerseyWebTarget(this.objectMapper, this.webTarget.resolveTemplate(name, value));
    }

    public JerseyWebTarget queryParam(String name, Object value) {
        if (value instanceof String) {
            value = UrlEscapers.urlPathSegmentEscaper().escape((String)value);
        }
        return new JerseyWebTarget(this.objectMapper, this.webTarget.queryParam(name, new Object[]{value}));
    }

    public JerseyWebTarget queryParamsSet(String name, Set<?> values) {
        return new JerseyWebTarget(this.objectMapper, this.webTarget.queryParam(name, values.toArray()));
    }

    public JerseyWebTarget queryParamsJsonMap(String name, Map<String, String> values) {
        if (values != null && !values.isEmpty()) {
            try {
                return this.queryParam(name, this.objectMapper.writeValueAsString(values));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }
}

