/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Volume;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Bind {
    private String path;
    private Volume volume;
    private boolean readOnly = false;

    public Bind(String path, Volume volume) {
        this(path, volume, false);
    }

    public Bind(String path, Volume volume, boolean readOnly) {
        this.path = path;
        this.volume = volume;
        this.readOnly = readOnly;
    }

    public String getPath() {
        return this.path;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static Bind parse(String serialized) {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 2: {
                    return new Bind(parts[0], Volume.parse(parts[1]));
                }
                case 3: {
                    if ("rw".equals(parts[2].toLowerCase())) {
                        return new Bind(parts[0], Volume.parse(parts[1]), false);
                    }
                    if ("ro".equals(parts[2].toLowerCase())) {
                        return new Bind(parts[0], Volume.parse(parts[1]), true);
                    }
                    throw new IllegalArgumentException();
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Bind '" + serialized + "'");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bind) {
            Bind other = (Bind)obj;
            return new EqualsBuilder().append((Object)this.path, (Object)other.getPath()).append((Object)this.volume, (Object)other.getVolume()).append(this.readOnly, other.isReadOnly()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.path).append((Object)this.volume).append(this.readOnly).toHashCode();
    }
}

