/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class ExposedPort {
    private String scheme;
    private int port;

    public ExposedPort(String scheme, int port) {
        this.scheme = scheme;
        this.port = port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public static ExposedPort tcp(int port) {
        return new ExposedPort("tcp", port);
    }

    public static ExposedPort udp(int port) {
        return new ExposedPort("udp", port);
    }

    public static ExposedPort parse(String serialized) {
        try {
            String[] parts = serialized.split("/");
            ExposedPort out = new ExposedPort(parts[1], Integer.valueOf(parts[0]));
            return out;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing ExposedPort '" + serialized + "'");
        }
    }

    public String toString() {
        return this.getPort() + "/" + this.getScheme();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExposedPort) {
            ExposedPort other = (ExposedPort)obj;
            return new EqualsBuilder().append((Object)this.scheme, (Object)other.getScheme()).append(this.port, other.getPort()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.scheme).append(this.port).toHashCode();
    }

    public static class Serializer
    extends JsonSerializer<ExposedPort> {
        public void serialize(ExposedPort exposedPort, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            jsonGen.writeFieldName(exposedPort.toString());
            jsonGen.writeEndObject();
        }
    }

    public static class Deserializer
    extends JsonDeserializer<ExposedPort> {
        public ExposedPort deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            if (!node.equals((Object)NullNode.getInstance())) {
                Map.Entry field = (Map.Entry)node.fields().next();
                return ExposedPort.parse((String)field.getKey());
            }
            return null;
        }
    }
}

