/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Link {
    private final String name;
    private final String alias;

    public Link(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public static Link parse(String serialized) {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 2: {
                    return new Link(parts[0], parts[1]);
                }
            }
            throw new RuntimeException("Error parsing Link '" + serialized + "'");
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing Link '" + serialized + "'");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link other = (Link)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.getName()).append((Object)this.alias, (Object)other.getAlias()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.alias).toHashCode();
    }
}

