/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.DockerClientException;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.core.CompressArchiveUtil;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class BuildImageCmdImpl
extends AbstrDockerCmd<BuildImageCmd, InputStream>
implements BuildImageCmd {
    private static final Pattern ADD_OR_COPY_PATTERN = Pattern.compile("^(ADD|COPY)\\s+(.*)\\s+(.*)$");
    private static final Pattern ENV_PATTERN = Pattern.compile("^ENV\\s+(.*)\\s+(.*)$");
    private InputStream tarInputStream = null;
    private String tag;
    private boolean noCache;
    private boolean remove = true;
    private boolean quiet;

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, File dockerFolder) {
        super(exec);
        Preconditions.checkNotNull((Object)dockerFolder, (Object)"dockerFolder is null");
        this.withTarInputStream(this.buildDockerFolderTar(dockerFolder));
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec, InputStream tarInputStream) {
        super(exec);
        Preconditions.checkNotNull((Object)tarInputStream, (Object)"tarInputStream is null");
        this.withTarInputStream(tarInputStream);
    }

    @Override
    public InputStream getTarInputStream() {
        return this.tarInputStream;
    }

    @Override
    public BuildImageCmdImpl withTarInputStream(InputStream tarInputStream) {
        Preconditions.checkNotNull((Object)tarInputStream, (Object)"tarInputStream is null");
        this.tarInputStream = tarInputStream;
        return this;
    }

    @Override
    public BuildImageCmdImpl withTag(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"Tag is null");
        this.tag = tag;
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean hasNoCacheEnabled() {
        return this.noCache;
    }

    @Override
    public boolean hasRemoveEnabled() {
        return this.remove;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public BuildImageCmdImpl withNoCache() {
        return this.withNoCache(true);
    }

    @Override
    public BuildImageCmdImpl withNoCache(boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    @Override
    public BuildImageCmdImpl withRemove() {
        return this.withRemove(true);
    }

    @Override
    public BuildImageCmdImpl withRemove(boolean rm) {
        this.remove = rm;
        return this;
    }

    @Override
    public BuildImageCmdImpl withQuiet() {
        return this.withQuiet(true);
    }

    @Override
    public BuildImageCmdImpl withQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    public String toString() {
        return "build " + (this.tag != null ? "-t " + this.tag + " " : "") + (this.noCache ? "--nocache=true " : "") + (this.quiet ? "--quiet=true " : "") + (!this.remove ? "--rm=false " : "");
    }

    protected InputStream buildDockerFolderTar(File dockerFolder) {
        Preconditions.checkArgument((boolean)dockerFolder.exists(), (String)"Path %s doesn't exist", (Object[])new Object[]{dockerFolder});
        Preconditions.checkArgument((boolean)dockerFolder.isDirectory(), (String)"Folder %s doesn't exist", (Object[])new Object[]{dockerFolder});
        Preconditions.checkState((boolean)new File(dockerFolder, "Dockerfile").exists(), (Object)("Dockerfile doesn't exist in " + dockerFolder));
        String archiveNameWithOutExtension = UUID.randomUUID().toString();
        File dockerFolderTar = null;
        try {
            File dockerFile = new File(dockerFolder, "Dockerfile");
            List dockerFileContent = FileUtils.readLines((File)dockerFile);
            if (dockerFileContent.size() <= 0) {
                throw new DockerClientException(String.format("Dockerfile %s is empty", dockerFile));
            }
            ArrayList<File> filesToAdd = new ArrayList<File>();
            filesToAdd.add(dockerFile);
            HashMap<String, String> environmentMap = new HashMap<String, String>();
            int lineNumber = 0;
            for (String cmd : dockerFileContent) {
                Matcher matcher;
                ++lineNumber;
                if (cmd.trim().isEmpty() || cmd.startsWith("#")) continue;
                Matcher envMatcher = ENV_PATTERN.matcher(cmd.trim());
                if (envMatcher.find()) {
                    if (envMatcher.groupCount() != 2) {
                        throw new DockerClientException(String.format("Wrong ENV format on line [%d]", lineNumber));
                    }
                    String variable = envMatcher.group(1).trim();
                    String value = envMatcher.group(2).trim();
                    environmentMap.put(variable, value);
                }
                if (!(matcher = ADD_OR_COPY_PATTERN.matcher(cmd.trim())).find()) continue;
                if (matcher.groupCount() != 3) {
                    throw new DockerClientException(String.format("Wrong ADD or COPY format on line [%d]", lineNumber));
                }
                String extractedResource = matcher.group(2);
                String resource = this.filterForEnvironmentVars(extractedResource, environmentMap).trim();
                if (!BuildImageCmdImpl.isFileResource(resource)) continue;
                File src = new File(resource);
                if (src.isAbsolute()) {
                    throw new DockerClientException(String.format("Source file %s must be relative to %s", src, dockerFolder));
                }
                src = new File(dockerFolder, resource).getCanonicalFile();
                if (!src.exists()) {
                    throw new DockerClientException(String.format("Source file %s doesn't exist", src));
                }
                if (src.isDirectory()) {
                    filesToAdd.addAll(FileUtils.listFiles((File)src, null, (boolean)true));
                    continue;
                }
                filesToAdd.add(src);
            }
            dockerFolderTar = CompressArchiveUtil.archiveTARFiles(dockerFolder, filesToAdd, archiveNameWithOutExtension);
            return FileUtils.openInputStream((File)dockerFolderTar);
        }
        catch (IOException ex) {
            FileUtils.deleteQuietly(dockerFolderTar);
            throw new DockerClientException("Error occurred while preparing Docker context folder.", ex);
        }
    }

    private String filterForEnvironmentVars(String extractedResource, Map<String, String> environmentMap) {
        if (environmentMap.size() > 0) {
            String currentResourceContent = extractedResource;
            for (Map.Entry<String, String> entry : environmentMap.entrySet()) {
                String variable = entry.getKey();
                String replacementValue = entry.getValue();
                currentResourceContent = currentResourceContent.replaceAll("\\$" + variable, replacementValue);
                currentResourceContent = currentResourceContent.replaceAll("\\$\\{" + variable + "\\}", replacementValue);
            }
            return currentResourceContent;
        }
        return extractedResource;
    }

    private static boolean isFileResource(String resource) {
        URI uri;
        try {
            uri = new URI(resource);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri.getScheme() == null || "file".equals(uri.getScheme());
    }
}

