/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import java.io.InputStream;

public class PullImageCmdImpl
extends AbstrDockerCmd<PullImageCmd, InputStream>
implements PullImageCmd {
    private String repository;
    private String tag;
    private String registry;

    public PullImageCmdImpl(PullImageCmd.Exec exec, String repository) {
        super(exec);
        this.withRepository(repository);
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public String getRegistry() {
        return this.registry;
    }

    @Override
    public PullImageCmd withRepository(String repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository was not specified");
        this.repository = repository;
        return this;
    }

    @Override
    public PullImageCmd withTag(String tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"tag was not specified");
        this.tag = tag;
        return this;
    }

    @Override
    public PullImageCmd withRegistry(String registry) {
        Preconditions.checkNotNull((Object)registry, (Object)"registry was not specified");
        this.registry = registry;
        return this;
    }

    public String toString() {
        return "pull " + this.repository + (this.tag != null ? ":" + this.tag : "");
    }
}

