/*
 * Decompiled with CFR 0.152.
 */
package ooxml2java2d.docx;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBElement;
import ooxml2java2d.GraphicsBuilder;
import ooxml2java2d.Renderer;
import ooxml2java2d.docx.internal.Alignment;
import ooxml2java2d.docx.internal.Column;
import ooxml2java2d.docx.internal.DrawImageAction;
import ooxml2java2d.docx.internal.DrawStringAction;
import ooxml2java2d.docx.internal.FontConfig;
import ooxml2java2d.docx.internal.FontStyle;
import ooxml2java2d.docx.internal.PageLayout;
import ooxml2java2d.docx.internal.ParagraphStyle;
import org.apache.commons.lang.StringUtils;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.Br;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STVerticalAlignRun;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.docx4j.wml.UnderlineEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocxRenderer
implements Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(DocxRenderer.class);
    private static final int TAB_WIDTH = 712;
    private static final int EMU_DIVISOR = 635;
    private GraphicsBuilder builder;
    private Graphics2D g;
    private WordprocessingMLPackage word;
    private MainDocumentPart main;
    private Deque<PageLayout> layouts = new ArrayDeque<PageLayout>();
    private PageLayout layout;
    private int page = 1;
    private int yOffset;
    private ParagraphStyle defaultParaStyle;
    private ParagraphStyle paraStyle;
    private ParagraphStyle runStyle;
    private RelationshipsPart relPart;

    public DocxRenderer(File docx) throws IOException {
        try {
            this.word = WordprocessingMLPackage.load((File)docx);
        }
        catch (Docx4JException e) {
            throw new IOException("Error loading document", e);
        }
    }

    @Override
    public void render(GraphicsBuilder builder) {
        this.builder = builder;
        this.main = this.word.getMainDocumentPart();
        this.setDefaultStyles();
        this.setPageLayouts(this.word);
        this.createPageFromNextLayout();
        this.iterateContentParts((ContentAccessor)this.main, new Column(this.layout.getLeftMargin(), this.layout.getWidth() - this.layout.getLeftMargin() - this.layout.getRightMargin()));
    }

    private void setDefaultStyles() {
        this.defaultParaStyle = this.getStyle(new ParagraphStyle(), ((StyleTree.AugmentedStyle)this.main.getStyleTree().getParagraphStylesTree().get("DocDefaults").getData()).getStyle().getRPr());
        if (this.main.getStyleDefinitionsPart().getDefaultParagraphStyle() != null) {
            this.defaultParaStyle = this.getStyle(this.defaultParaStyle, this.main.getStyleDefinitionsPart().getDefaultParagraphStyle());
        }
    }

    private void setPageLayouts(WordprocessingMLPackage word) {
        for (SectionWrapper sw : word.getDocumentModel().getSections()) {
            this.layouts.add(this.createPageLayout(sw));
        }
    }

    private PageLayout createPageLayout(SectionWrapper sw) {
        SectPr sectPr = sw.getSectPr();
        SectPr.PgSz size = sectPr.getPgSz();
        SectPr.PgMar margin = sectPr.getPgMar();
        return new PageLayout(size.getW().intValue(), size.getH().intValue(), margin.getTop().intValue(), margin.getRight().intValue(), margin.getBottom().intValue(), margin.getLeft().intValue(), margin.getHeader().intValue(), sw.getHeaderFooterPolicy());
    }

    private void createPageFromNextLayout() {
        this.layout = this.layouts.removeFirst();
        this.createPageFromLayout();
    }

    private void createPageFromLayout() {
        Graphics2D g2 = this.builder.nextPage(this.layout.getWidth(), this.layout.getHeight());
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, this.layout.getWidth(), this.layout.getHeight());
        g2.setColor(Color.BLACK);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, 250);
        if (this.g != null) {
            g2.setFont(this.g.getFont());
            g2.setColor(this.g.getColor());
        }
        this.g = g2;
        HeaderPart header = null;
        if (this.page == 1) {
            header = this.layout.getHeaderFooterPolicy().getFirstHeader();
        }
        if (header == null) {
            header = this.layout.getHeaderFooterPolicy().getHeader(this.page);
        }
        if (header == null) {
            header = this.layout.getHeaderFooterPolicy().getDefaultHeader();
        }
        if (header != null) {
            this.yOffset = this.layout.getHeaderMargin();
            this.relPart = header.getRelationshipsPart(false);
            this.iterateContentParts((ContentAccessor)header, new Column(this.layout.getLeftMargin(), this.layout.getWidth()));
        }
        ++this.page;
        this.relPart = this.main.getRelationshipsPart();
        this.yOffset = this.layout.getTopMargin();
    }

    private void iterateContentParts(ContentAccessor ca, Column column) {
        for (Object obj : ca.getContent()) {
            if (obj instanceof P) {
                if (!this.processParagraph((P)obj, column)) continue;
                column = new Column(this.layout.getLeftMargin(), this.layout.getWidth() - this.layout.getLeftMargin() - this.layout.getRightMargin());
                continue;
            }
            if (obj instanceof R) {
                this.processTextRun((R)obj, column);
                continue;
            }
            if (obj instanceof Br) {
                this.processBreak((Br)obj, column);
                continue;
            }
            if (obj instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)obj;
                if (element.getDeclaredType().equals(Text.class)) {
                    this.processText(((Text)element.getValue()).getValue(), column);
                    continue;
                }
                if (element.getDeclaredType().equals(R.Tab.class)) {
                    this.processTab((R.Tab)element.getValue(), column);
                    continue;
                }
                if (element.getDeclaredType().equals(Tbl.class)) {
                    this.processTable((Tbl)element.getValue(), column);
                    continue;
                }
                if (element.getDeclaredType().equals(Drawing.class)) {
                    this.processDrawing((Drawing)element.getValue(), column);
                    continue;
                }
                LOG.debug("Unhandled JAXBElement object " + element.getDeclaredType());
                continue;
            }
            LOG.debug("Unhandled document object " + obj.getClass());
        }
    }

    private boolean processParagraph(P p, Column column) {
        PPr properties = p.getPPr();
        ParagraphStyle newParaStyle = new ParagraphStyle(this.defaultParaStyle);
        if (properties != null) {
            if (properties.getPStyle() != null) {
                PPrBase.PStyle pstyle = properties.getPStyle();
                newParaStyle = this.getStyleById(this.defaultParaStyle, pstyle.getVal());
            }
            if (properties.getJc() != null) {
                switch (properties.getJc().getVal()) {
                    case RIGHT: {
                        newParaStyle.setAlignment(Alignment.RIGHT);
                        break;
                    }
                    case CENTER: {
                        newParaStyle.setAlignment(Alignment.CENTER);
                        break;
                    }
                }
            }
        }
        this.yOffset += newParaStyle.getSpaceBefore();
        this.paraStyle = newParaStyle;
        if (p.getContent().size() == 0) {
            this.yOffset = (int)((double)this.yOffset + this.paraStyle.getStringBoxSize("").getHeight());
        } else {
            this.iterateContentParts((ContentAccessor)p, column);
        }
        this.renderActionsForLine(column);
        this.yOffset += this.paraStyle.getSpaceAfter();
        if (properties != null && properties.getSectPr() != null) {
            this.createPageFromNextLayout();
            return true;
        }
        return false;
    }

    private void processTextRun(R run, Column column) {
        ParagraphStyle newRunStyle = this.getStyle(this.paraStyle, run.getRPr());
        if (this.runStyle == null || !newRunStyle.getFontConfig().equals(this.runStyle.getFontConfig())) {
            column.addAction(newRunStyle.getFontConfig());
        }
        if (this.runStyle == null || !newRunStyle.getColor().equals(this.runStyle.getColor())) {
            column.addAction(new Color(newRunStyle.getColor().getRGB()));
        }
        this.runStyle = newRunStyle;
        if (run.getRPr() != null && run.getContent().size() == 0) {
            this.yOffset = (int)((double)this.yOffset + this.paraStyle.getStringBoxSize("").getHeight());
        } else {
            this.iterateContentParts((ContentAccessor)run, column);
        }
    }

    private void processBreak(Br br, Column column) {
        if (br.getType() == null) {
            this.renderActionsForLine(column);
        } else {
            switch (br.getType()) {
                case PAGE: {
                    this.renderActionsForLine(column);
                    this.createPageFromLayout();
                    break;
                }
                default: {
                    LOG.debug("Unhandled break type " + br.getType());
                }
            }
        }
    }

    private void processText(String text, Column column) {
        Rectangle2D bounds = this.runStyle.getStringBoxSize(text);
        if (column.canFitContent(bounds.getWidth())) {
            column.addContent(bounds.getWidth(), bounds.getHeight(), new DrawStringAction(text, column.getContentWidth(), 0));
        } else {
            String[] words = text.split(" ");
            String newText = "";
            for (int i = 0; i < words.length; ++i) {
                bounds = newText.isEmpty() ? this.runStyle.getStringBoxSize(words[i]) : this.runStyle.getStringBoxSize(newText + " " + words[i]);
                if (!column.canFitContent(bounds.getWidth())) {
                    if (i != 0) break;
                    char[] chars = text.toCharArray();
                    for (int k = 0; k < chars.length && column.canFitContent((bounds = this.runStyle.getStringBoxSize(newText + chars[k])).getWidth()); ++k) {
                        newText = newText + chars[k];
                    }
                    continue;
                }
                newText = newText.isEmpty() ? words[i] : newText + " " + words[i];
            }
            bounds = this.runStyle.getStringBoxSize(newText);
            String nextText = text.substring(newText.length()).trim();
            if (nextText.equals(text)) {
                LOG.error("Unable to fit content, skipping: " + nextText);
            } else {
                column.addContent(bounds.getWidth(), bounds.getHeight(), new DrawStringAction(newText, column.getContentWidth(), 0));
                this.renderActionsForLine(column);
                this.processText(nextText, column);
            }
        }
    }

    private void processTab(R.Tab tab, Column column) {
        column.addContentOffset(712 - column.getContentWidth() % 712);
    }

    private void processTable(Tbl table, Column column) {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (TblGridCol tableColumn : table.getTblGrid().getGridCol()) {
            columnWidths.add(tableColumn.getW().intValue());
        }
        for (Object tblObj : table.getContent()) {
            if (!(tblObj instanceof Tr)) continue;
            Tr tableRow = (Tr)tblObj;
            ArrayList<Integer> columnYOffsets = new ArrayList<Integer>();
            int xOffset = column.getXOffset();
            int col = 0;
            for (int i = 0; i < columnWidths.size(); ++i) {
                columnYOffsets.add(this.yOffset);
            }
            ArrayList<Column> cacheColumns = new ArrayList<Column>();
            int maxYOffset = 0;
            for (Object rowObj : tableRow.getContent()) {
                if (rowObj instanceof JAXBElement) {
                    JAXBElement element = (JAXBElement)rowObj;
                    if (!element.getDeclaredType().equals(Tc.class)) continue;
                    Tc tableCell = (Tc)element.getValue();
                    int width = (Integer)columnWidths.get(col);
                    if (tableCell.getTcPr().getGridSpan() != null) {
                        int mergeCols = tableCell.getTcPr().getGridSpan().getVal().intValue();
                        width = (Integer)columnWidths.get(col);
                        for (int i = 0; i < mergeCols - 1; ++i) {
                            width += ((Integer)columnWidths.get(++col)).intValue();
                        }
                    }
                    Column cellColumn = new Column(xOffset, width);
                    cellColumn.setCacheOverPageFold(true);
                    this.yOffset = (Integer)columnYOffsets.get(col);
                    this.iterateContentParts((ContentAccessor)tableCell, cellColumn);
                    columnYOffsets.set(col, this.yOffset);
                    xOffset += cellColumn.getWidth();
                    ++col;
                    maxYOffset = Math.max(maxYOffset, this.yOffset);
                    if (!cellColumn.hasContent()) continue;
                    cacheColumns.add(cellColumn);
                    continue;
                }
                LOG.debug("Unhandled row object " + rowObj.getClass());
            }
            if (cacheColumns.size() > 0) {
                int start;
                this.createPageFromLayout();
                maxYOffset = start = this.yOffset;
                for (Column cacheColumn : cacheColumns) {
                    cacheColumn.setCacheOverPageFold(false);
                    this.yOffset = start;
                    this.renderActionsForLine(cacheColumn);
                    maxYOffset = Math.max(maxYOffset, this.yOffset);
                }
                continue;
            }
            this.yOffset = maxYOffset;
        }
    }

    private void processDrawing(Drawing drawing, Column column) {
        for (Object obj : drawing.getAnchorOrInline()) {
            if (obj instanceof Inline) {
                Inline inline = (Inline)obj;
                this.processGraphic(inline.getExtent(), inline.getGraphic(), column);
                continue;
            }
            if (obj instanceof Anchor) {
                Anchor anchor = (Anchor)obj;
                if (anchor.isBehindDoc()) {
                    int width = (int)anchor.getExtent().getCx() / 635;
                    int height = (int)anchor.getExtent().getCy() / 635;
                    int x = anchor.getPositionH().getPosOffset() / 635;
                    int y = anchor.getPositionV().getPosOffset() / 635;
                    try {
                        BufferedImage bi = this.getImage(anchor.getGraphic().getGraphicData().getPic().getBlipFill().getBlip().getEmbed());
                        this.g.drawImage(bi, x, y, width, height, null);
                    }
                    catch (IOException ioe) {
                        LOG.error("Error reading image", (Throwable)ioe);
                    }
                    continue;
                }
                this.processGraphic(anchor.getExtent(), anchor.getGraphic(), column);
                continue;
            }
            LOG.debug("Unhandled drawing object " + obj.getClass());
        }
    }

    private void processGraphic(CTPositiveSize2D extent, Graphic graphic, Column column) {
        int width = (int)extent.getCx() / 635;
        int height = (int)extent.getCy() / 635;
        if (!column.canFitContent(width)) {
            this.renderActionsForLine(column);
        }
        String rId = graphic.getGraphicData().getPic().getBlipFill().getBlip().getEmbed();
        column.addContentForced(width, height, new DrawImageAction(rId, width, height, column.getContentWidth()));
    }

    private ParagraphStyle getStyleById(ParagraphStyle baseStyle, String styleId) {
        return this.getStyle(baseStyle, this.main.getStyleDefinitionsPart().getStyleById(styleId));
    }

    private ParagraphStyle getStyle(ParagraphStyle baseStyle, Style style) {
        PPrBase.Spacing spacing;
        if (style == null) {
            return baseStyle;
        }
        ParagraphStyle newStyle = style.getBasedOn() == null ? new ParagraphStyle(baseStyle) : this.getStyleById(baseStyle, style.getBasedOn().getVal());
        if (style.getPPr() != null && (spacing = style.getPPr().getSpacing()) != null) {
            if (spacing.getLine() != null) {
                newStyle.setLineSpacing(spacing.getLine().intValue());
            }
            if (spacing.getBefore() != null) {
                newStyle.setSpaceBefore(spacing.getBefore().intValue());
            }
            if (spacing.getAfter() != null) {
                newStyle.setSpaceAfter(spacing.getAfter().intValue());
            }
        }
        return this.getStyle(newStyle, style.getRPr());
    }

    private ParagraphStyle getStyle(ParagraphStyle baseStyle, RPr runProperties) {
        float sizePt;
        if (runProperties == null) {
            return baseStyle;
        }
        ParagraphStyle newStyle = new ParagraphStyle(baseStyle);
        if (runProperties.getRFonts() != null && runProperties.getRFonts().getAscii() != null) {
            newStyle.setFontName(runProperties.getRFonts().getAscii());
        }
        if (runProperties.getSz() != null) {
            sizePt = runProperties.getSz().getVal().floatValue() / 2.0f;
            newStyle.setFontSize(sizePt * 20.0f);
        } else if (runProperties.getSzCs() != null) {
            sizePt = runProperties.getSzCs().getVal().floatValue() / 2.0f;
            newStyle.setFontSize(sizePt * 20.0f);
        }
        if (runProperties.getB() != null) {
            newStyle.enableFontStyle(FontStyle.BOLD);
        }
        if (runProperties.getI() != null) {
            newStyle.enableFontStyle(FontStyle.ITALIC);
        }
        if (runProperties.getStrike() != null) {
            newStyle.enableFontStyle(FontStyle.STRIKETHROUGH);
        }
        if (runProperties.getU() != null && runProperties.getU().getVal().equals((Object)UnderlineEnumeration.SINGLE)) {
            newStyle.enableFontStyle(FontStyle.UNDERLINE);
        }
        if (runProperties.getVertAlign() != null && runProperties.getVertAlign().getVal().equals((Object)STVerticalAlignRun.SUPERSCRIPT)) {
            newStyle.enableFontStyle(FontStyle.SUPERSCRIPT);
        }
        if (runProperties.getColor() != null) {
            Color newColor;
            String strColor = runProperties.getColor().getVal();
            if (strColor.equals("auto")) {
                newColor = Color.BLACK;
            } else {
                String hex = StringUtils.leftPad((String)strColor, (int)6, (char)'0');
                newColor = new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            if (!newColor.equals(baseStyle.getColor())) {
                newStyle.setColor(newColor);
            }
        }
        return newStyle;
    }

    private void renderActionsForLine(Column column) {
        if (this.yOffset + column.getContentHeight() > this.layout.getHeight() - this.layout.getBottomMargin()) {
            if (column.isCachedOverPageFold()) {
                return;
            }
            this.createPageFromLayout();
        }
        this.yOffset += column.getContentHeight();
        int alignmentOffset = column.getXOffset();
        switch (this.paraStyle.getAlignment()) {
            case RIGHT: {
                alignmentOffset += column.getWidth() - column.getContentWidth();
                break;
            }
            case CENTER: {
                alignmentOffset += (column.getWidth() - column.getContentWidth()) / 2;
                break;
            }
        }
        for (Object obj : column.getActions()) {
            if (obj instanceof DrawStringAction) {
                DrawStringAction ds = (DrawStringAction)obj;
                this.g.drawString(ds.getText(), alignmentOffset + ds.getX(), this.yOffset);
                continue;
            }
            if (obj instanceof Color) {
                this.g.setColor((Color)obj);
                continue;
            }
            if (obj instanceof FontConfig) {
                FontConfig fc = (FontConfig)obj;
                this.g.setFont(fc.getFont());
                continue;
            }
            if (!(obj instanceof DrawImageAction)) continue;
            DrawImageAction di = (DrawImageAction)obj;
            try {
                BufferedImage bi = this.getImage(di.getRelationshipId());
                if (bi == null) {
                    LOG.error("Error creating image for " + di.getRelationshipId());
                    continue;
                }
                this.g.drawImage(bi, alignmentOffset + di.getX(), this.yOffset - di.getHeight(), di.getWidth(), di.getHeight(), null);
            }
            catch (IOException ioe) {
                LOG.error("Error reading image", (Throwable)ioe);
            }
        }
        column.reset();
    }

    private BufferedImage getImage(String relationshipId) throws IOException {
        BinaryPart binary = (BinaryPart)this.relPart.getPart(relationshipId);
        return ImageIO.read(new ByteArrayInputStream(binary.getBytes()));
    }
}

