/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.column;

import com.github.jasync.sql.db.column.ColumnDecoder;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.postgresql.util.ArrayStreamingParser;
import com.github.jasync.sql.db.postgresql.util.ArrayStreamingParserDelegate;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0004\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/ArrayDecoder;", "Lcom/github/jasync/sql/db/column/ColumnDecoder;", "decoder", "(Lcom/github/jasync/sql/db/column/ColumnDecoder;)V", "decode", "", "", "kind", "Lcom/github/jasync/sql/db/general/ColumnData;", "value", "Lio/netty/buffer/ByteBuf;", "charset", "Ljava/nio/charset/Charset;", "", "jasync-postgresql"})
public final class ArrayDecoder
implements ColumnDecoder {
    @NotNull
    private final ColumnDecoder decoder;

    public ArrayDecoder(@NotNull ColumnDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        this.decoder = decoder;
    }

    @Nullable
    public List<Object> decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        byte[] bytes = new byte[value.readableBytes()];
        value.readBytes(bytes);
        String valueString = new String(bytes, charset);
        Ref.ObjectRef stack = new Ref.ObjectRef();
        stack.element = new ArrayList();
        Ref.ObjectRef current = new Ref.ObjectRef();
        Ref.ObjectRef result = new Ref.ObjectRef();
        ArrayStreamingParserDelegate delegate2 = new ArrayStreamingParserDelegate((Ref.ObjectRef<List<Object>>)result, (Ref.ObjectRef<List<List<Object>>>)stack, this, kind, charset, (Ref.ObjectRef<List<Object>>)current){
            final /* synthetic */ Ref.ObjectRef<List<Object>> $result;
            final /* synthetic */ Ref.ObjectRef<List<List<Object>>> $stack;
            final /* synthetic */ ArrayDecoder this$0;
            final /* synthetic */ ColumnData $kind;
            final /* synthetic */ Charset $charset;
            final /* synthetic */ Ref.ObjectRef<List<Object>> $current;
            {
                this.$result = $result;
                this.$stack = $stack;
                this.this$0 = $receiver;
                this.$kind = $kind;
                this.$charset = $charset;
                this.$current = $current;
            }

            public void arrayEnded() {
                this.$result.element = CollectionsUtilsKt.getHead((List)((List)this.$stack.element));
                this.$stack.element = CollectionsKt.toMutableList((Collection)CollectionsUtilsKt.getTail((List)((List)this.$stack.element)));
            }

            public void elementFound(@NotNull String element) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (ArrayDecoder.access$getDecoder$p(this.this$0).supportsStringDecoding()) {
                    object = ArrayDecoder.access$getDecoder$p(this.this$0).decode(element);
                } else {
                    ColumnDecoder columnDecoder = ArrayDecoder.access$getDecoder$p(this.this$0);
                    byte[] byArray = element.getBytes(this.$charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])byArray);
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(element.toByteArray(charset))");
                    object = columnDecoder.decode(this.$kind, byteBuf, this.$charset);
                }
                Object foundResult = object;
                Object object2 = this.$current.element;
                Intrinsics.checkNotNull((Object)object2);
                ((List)object2).add(foundResult);
            }

            public void nullElementFound() {
                Object object = this.$current.element;
                Intrinsics.checkNotNull((Object)object);
                ((List)object).add(null);
            }

            public void arrayStarted() {
                this.$current.element = new ArrayList<E>();
                if (!((Collection)this.$stack.element).isEmpty()) {
                    Object object = CollectionsUtilsKt.getHead((List)((List)this.$stack.element));
                    Intrinsics.checkNotNull((Object)object);
                    ((List)object).add(this.$current.element);
                }
                ((List)this.$stack.element).add(0, this.$current.element);
            }
        };
        ArrayStreamingParser.INSTANCE.parse(valueString, delegate2);
        return (List)result.element;
    }

    @NotNull
    public Object decode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new UnsupportedOperationException("Should not be called");
    }

    public boolean supportsStringDecoding() {
        return ColumnDecoder.DefaultImpls.supportsStringDecoding((ColumnDecoder)this);
    }

    public static final /* synthetic */ ColumnDecoder access$getDecoder$p(ArrayDecoder $this) {
        return $this.decoder;
    }
}

