/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jjschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.RawProcessor;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.CanonicalSchemaTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.tree.key.SchemaKey;
import com.github.reinert.jjschema.v1.JsonSchemaFactory;
import com.github.reinert.jjschema.v1.JsonSchemaV4Factory;

public final class JJSchemaProcessor
extends RawProcessor<Class<?>, SchemaTree> {
    private static final JsonSchemaFactory FACTORY = new JsonSchemaV4Factory();

    public JJSchemaProcessor() {
        super("class", "schema");
    }

    protected SchemaTree rawProcess(ProcessingReport report, Class<?> input) throws ProcessingException {
        ProcessingMessage message = this.newMessage(input);
        report.debug(message.setMessage("processing"));
        JsonNode node = FACTORY.createSchema(input);
        return new CanonicalSchemaTree(SchemaKey.anonymousKey(), node);
    }

    static {
        FACTORY.setAutoPutDollarSchema(true);
    }
}

