/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchInput;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.util.ValueHolder;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;

public final class JsonPatchProcessor
implements Processor<JsonPatchInput, ValueHolder<JsonNode>> {
    private static final JsonSchema SCHEMA;

    public ValueHolder<JsonNode> process(ProcessingReport report, JsonPatchInput input) throws ProcessingException {
        JsonNode rawPatch = input.getRawPatch();
        report.mergeWith(SCHEMA.validate(rawPatch));
        if (!report.isSuccess()) {
            throw new ProcessingException(input.newMessage().setMessage("illegal JSON patch"));
        }
        try {
            JsonPatch patch = JsonPatch.fromJson((JsonNode)rawPatch);
            JsonNode ret = patch.apply(input.getNode());
            return ValueHolder.hold((String)"result", (Object)ret);
        }
        catch (JsonPatchException e) {
            throw new ProcessingException(input.newMessage().setMessage("failed to apply patch"), (Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException(input.newMessage().setMessage("patch considered invalid but schema validated it"), (Throwable)e);
        }
    }

    static {
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        try {
            JsonNode node = JsonLoader.fromResource((String)"/json-patch.json");
            SCHEMA = factory.getJsonSchema(node);
        }
        catch (ProcessingException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

