/*
 * Decompiled with CFR 0.152.
 */
package org.jmicrostack.karaf.python;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jmicrostack.karaf.python.PythonSimpleResult;
import org.jmicrostack.karaf.python.api.PythonVersion;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonSimple {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonSimple.class);
    private PythonVersion pyEngine;
    private Bundle context;
    private String systemUserName;

    public PythonSimple() {
        this.pyEngine = PythonVersion.PYTHON3;
    }

    public PythonSimple(PythonVersion pyVerison) {
        this.pyEngine = pyVerison;
    }

    public PythonSimple(PythonVersion pyVerison, Bundle context) {
        this.pyEngine = pyVerison;
        this.context = context;
    }

    public void setPythonVersion(PythonVersion pyVerison) {
        this.pyEngine = pyVerison;
    }

    public void setContext(Bundle context) {
        this.context = context;
    }

    public void setSystemUserName(String userName) {
        this.systemUserName = userName;
    }

    public String getSystemUserName() {
        return this.systemUserName;
    }

    public PythonSimpleResult run(URI pathToScript, Object data, String args, String[] env) throws IOException {
        StringBuffer error;
        StringBuffer result;
        Process pyProcess;
        block10: {
            if (args == null) {
                args = "";
            }
            Path basePath = Paths.get("scripts", this.context.getSymbolicName(), this.context.getVersion().toString(), "python", pathToScript.toString()).toAbsolutePath();
            pyProcess = this.systemUserName == null ? (args.length() > 0 ? Runtime.getRuntime().exec(new String[]{this.pyEngine.getEngineName(), basePath.toString(), args}, new String[]{"PYWORK_HOME=" + basePath.getParent().toString(), "KARAF_HOME=" + System.getProperty("karaf.home")}) : Runtime.getRuntime().exec(new String[]{this.pyEngine.getEngineName(), basePath.toString()}, new String[]{"PYWORK_HOME=" + basePath.getParent().toString(), "KARAF_HOME=" + System.getProperty("karaf.home")})) : (args.length() > 0 ? Runtime.getRuntime().exec(new String[]{"sudo", "-Eu", this.systemUserName, this.pyEngine.getEngineName(), basePath.toString(), args}, new String[]{"PYWORK_HOME=" + basePath.getParent().toString(), "KARAF_HOME=" + System.getProperty("karaf.home"), "HOME=/home/" + this.systemUserName}) : Runtime.getRuntime().exec(new String[]{"sudo", "-Eu", this.systemUserName, this.pyEngine.getEngineName(), basePath.toString()}, new String[]{"PYWORK_HOME=" + basePath.getParent().toString(), "KARAF_HOME=" + System.getProperty("karaf.home"), "HOME=/home/" + this.systemUserName}));
            BufferedReader sreader = new BufferedReader(new InputStreamReader(pyProcess.getInputStream(), "UTF8"));
            BufferedReader serror = new BufferedReader(new InputStreamReader(pyProcess.getErrorStream(), "UTF8"));
            BufferedWriter sdata = new BufferedWriter(new OutputStreamWriter(pyProcess.getOutputStream(), "UTF8"));
            result = new StringBuffer();
            error = new StringBuffer();
            try {
                String line;
                if (data != null) {
                    sdata.write(data.toString());
                    sdata.close();
                }
                StringBuffer errbuffer = new StringBuffer();
                do {
                    if (serror.ready()) {
                        int cherror = serror.read();
                        errbuffer.append((char)cherror);
                        if ((char)cherror == '\n' || (char)cherror == '\r') {
                            line = errbuffer.toString();
                            if (line.startsWith("Python ")) {
                                this.logPythonMessage(line);
                            } else {
                                error.append(line);
                            }
                            errbuffer = new StringBuffer();
                        }
                    }
                    if (!sreader.ready()) continue;
                    int chdata = sreader.read();
                    result.append((char)chdata);
                } while (pyProcess.isAlive() || serror.ready() || sreader.ready());
                if (errbuffer.length() <= 0) break block10;
                error.append(errbuffer.toString());
                line = errbuffer.toString();
                if (!line.startsWith("Python ")) break block10;
                this.logPythonMessage(line);
            }
            catch (Exception e) {
                int cherror;
                while ((cherror = serror.read()) > -1) {
                    error.append((char)cherror);
                }
            }
        }
        pyProcess.destroy();
        return new PythonSimpleResult(result.toString(), error.toString());
    }

    private void logPythonMessage(String message) {
        if (message.startsWith("Python INFO")) {
            LOGGER.info(message.trim());
        } else if (message.startsWith("Python ERROR")) {
            LOGGER.error(message.trim());
        } else if (message.startsWith("Python WARN")) {
            LOGGER.warn(message.trim());
        } else {
            LOGGER.info(message.trim());
        }
    }
}

