/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.CommandListener;
import com.github.johnnyjayjay.discord.commandapi.CommandSetException;
import com.github.johnnyjayjay.discord.commandapi.ICommand;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.bot.sharding.ShardManager;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.MessageBuilder;
import net.dv8tion.jda.core.entities.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandSettings {
    public static final String VALID_PREFIX = "[^\\\\+*^|$?]+";
    public static final String VALID_LABEL = "[^\\s]+";
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"CommandAPI");
    private final String INVALID_PREFIX_MESSAGE = "Prefix cannot be empty or contain the characters +*^|$\\?";
    private final String INVALID_LABEL_MESSAGE = "Label cannot be empty, consist of multiple words or contain new lines!";
    private Message unknownCommandMessage;
    private String defaultPrefix;
    private long cooldown = 0L;
    private Color helpColor = null;
    private final Set<Long> blacklistedChannels;
    @Deprecated
    private Set<String> helpLabels;
    private final Map<Long, String> prefixMap;
    private final Map<String, ICommand> commands = new HashMap<String, ICommand>();
    private Object jda;
    private final CommandListener listener = new CommandListener(this);
    private boolean activated = false;
    private boolean useShardManager;
    private boolean labelIgnoreCase;
    private boolean resetCooldown;
    private boolean botExecution = false;

    public CommandSettings(@Nonnull String defaultPrefix, @Nonnull ShardManager shardManager, boolean labelIgnoreCase) {
        this(defaultPrefix, labelIgnoreCase);
        this.jda = shardManager;
        this.useShardManager = true;
    }

    public CommandSettings(@Nonnull String defaultPrefix, @Nonnull JDA jda, boolean labelIgnoreCase) {
        this(defaultPrefix, labelIgnoreCase);
        this.jda = jda;
        this.useShardManager = false;
    }

    private CommandSettings(@Nonnull String defaultPrefix, boolean labelIgnoreCase) {
        this.setDefaultPrefix(defaultPrefix);
        this.labelIgnoreCase = labelIgnoreCase;
        this.resetCooldown = false;
        this.helpLabels = new HashSet<String>();
        this.blacklistedChannels = new HashSet<Long>();
        this.prefixMap = new HashMap<Long, String>();
    }

    @Deprecated
    public CommandSettings addHelpLabel(String label) {
        if (!label.matches(VALID_LABEL)) {
            throw new CommandSetException("Label cannot be empty, consist of multiple words or contain new lines!");
        }
        this.helpLabels.add(this.labelIgnoreCase ? label.toLowerCase() : label);
        return this;
    }

    @Deprecated
    public CommandSettings addHelpLabels(String ... labels) {
        for (String label : labels) {
            this.addHelpLabel(label);
        }
        return this;
    }

    @Deprecated
    public CommandSettings addHelpLabels(@Nonnull Collection<String> labels) {
        this.helpLabels.addAll(this.labelIgnoreCase ? (Collection)labels.stream().map(String::toLowerCase).collect(Collectors.toList()) : labels);
        return this;
    }

    @Deprecated
    public boolean removeHelpLabel(String label) {
        return this.helpLabels.remove(this.labelIgnoreCase ? label.toLowerCase() : label);
    }

    @Deprecated
    public boolean removeHelpLabels(String ... labels) {
        boolean success = true;
        for (String label : labels) {
            if (this.removeHelpLabel(label)) continue;
            success = false;
        }
        return success;
    }

    @Deprecated
    public boolean removeHelpLabels(@Nonnull Collection<String> labels) {
        return this.helpLabels.removeAll(this.labelIgnoreCase ? (Collection)labels.stream().map(String::toLowerCase).collect(Collectors.toList()) : labels);
    }

    @Deprecated
    public CommandSettings clearHelpLabels() {
        this.helpLabels.clear();
        return this;
    }

    public CommandSettings addChannelToBlacklist(long channelId) {
        this.blacklistedChannels.add(channelId);
        return this;
    }

    public CommandSettings addChannelsToBlacklist(long ... channelIds) {
        for (long id : channelIds) {
            this.addChannelToBlacklist(id);
        }
        return this;
    }

    public CommandSettings addChannelsToBlacklist(Collection<Long> channelIds) {
        this.blacklistedChannels.addAll(channelIds);
        return this;
    }

    public boolean removeChannelFromBlacklist(long channelId) {
        return this.blacklistedChannels.remove(channelId);
    }

    public boolean removeChannelsFromBlacklist(long ... channelIds) {
        boolean success = true;
        for (long id : channelIds) {
            if (this.removeChannelFromBlacklist(id)) continue;
            success = false;
        }
        return success;
    }

    public boolean removeChannelsFromBlackList(Collection<Long> channelIds) {
        return this.blacklistedChannels.removeAll(channelIds);
    }

    public CommandSettings clearBlacklist() {
        this.blacklistedChannels.clear();
        return this;
    }

    public CommandSettings put(@Nonnull ICommand executor, String label) {
        if (!label.matches(VALID_LABEL)) {
            throw new CommandSetException("Label cannot be empty, consist of multiple words or contain new lines!", new IllegalArgumentException("Label " + label + " is not valid"));
        }
        this.commands.put(this.labelIgnoreCase ? label.toLowerCase() : label, executor);
        return this;
    }

    public CommandSettings put(@Nonnull ICommand executor, String ... labels) {
        for (String label : labels) {
            this.put(executor, label);
        }
        return this;
    }

    public CommandSettings put(@Nonnull ICommand executor, @Nonnull Collection<String> labels) {
        this.put(executor, labels.toArray(new String[0]));
        return this;
    }

    public boolean remove(String label) {
        return this.commands.remove(this.labelIgnoreCase ? label.toLowerCase() : label) != null;
    }

    public boolean remove(String ... labels) {
        boolean success = true;
        for (String label : labels) {
            if (this.remove(label)) continue;
            success = false;
        }
        return success;
    }

    public boolean remove(@Nonnull Collection<String> labels) {
        return this.remove(labels.toArray(new String[0]));
    }

    public CommandSettings clearCommands() {
        this.commands.clear();
        return this;
    }

    public CommandSettings clear() {
        this.clearBlacklist().clearCommands().clearCustomPrefixes();
        this.botExecution = false;
        this.cooldown = 0L;
        this.helpColor = null;
        this.resetCooldown = false;
        if (this.activated) {
            this.deactivate();
        }
        return this;
    }

    public CommandSettings setDefaultPrefix(@Nonnull String prefix) {
        if (!prefix.matches(VALID_PREFIX)) {
            throw new CommandSetException("Prefix cannot be empty or contain the characters +*^|$\\?", new IllegalArgumentException("Prefix " + prefix + " is not valid"));
        }
        this.defaultPrefix = prefix;
        return this;
    }

    public CommandSettings setUnknownCommandMessage(@Nullable Message message) {
        this.unknownCommandMessage = message == null ? null : new MessageBuilder(message).build();
        return this;
    }

    public CommandSettings setCustomPrefix(long guildId, @Nullable String prefix) {
        if (prefix != null && !prefix.matches(VALID_PREFIX)) {
            throw new CommandSetException("Prefix cannot be empty or contain the characters +*^|$\\?", new IllegalArgumentException("Prefix " + prefix + " is not valid"));
        }
        this.prefixMap.put(guildId, prefix);
        return this;
    }

    public CommandSettings setCustomPrefixes(@Nonnull Map<Long, String> guildIdPrefixMap) {
        if (!guildIdPrefixMap.values().stream().allMatch(prefix -> prefix.matches(VALID_PREFIX))) {
            throw new CommandSetException("One or more of the prefixes is not valid: Prefix cannot be empty or contain the characters +*^|$\\?", new IllegalArgumentException("Invalid prefix"));
        }
        this.prefixMap.putAll(guildIdPrefixMap);
        return this;
    }

    public CommandSettings clearCustomPrefixes() {
        this.prefixMap.clear();
        return this;
    }

    public CommandSettings setCooldown(long msCooldown) {
        this.cooldown = msCooldown;
        return this;
    }

    public CommandSettings setResetCooldown(boolean resetCooldown) {
        this.resetCooldown = resetCooldown;
        return this;
    }

    public CommandSettings setBotExecution(boolean botExecution) {
        this.botExecution = botExecution;
        return this;
    }

    public CommandSettings setHelpCommandColor(@Nullable Color color) {
        this.helpColor = color;
        return this;
    }

    public void activate() {
        if (!this.activated) {
            if (this.useShardManager) {
                ((ShardManager)this.jda).addEventListener(new Object[]{this.listener});
            } else {
                ((JDA)this.jda).addEventListener(new Object[]{this.listener});
            }
        } else {
            throw new CommandSetException("CommandSettings already activated!", new IllegalStateException("Cannot activate CommandSettings in current state"));
        }
        this.activated = true;
        LOGGER.info("CommandSettings were activated");
    }

    public void deactivate() {
        if (this.activated) {
            if (this.useShardManager) {
                ((ShardManager)this.jda).removeEventListener(new Object[]{this.listener});
            } else {
                ((JDA)this.jda).removeEventListener(new Object[]{this.listener});
            }
        } else {
            throw new CommandSetException("CommandSettings weren't activated yet and can therefore not be deactivated!", new IllegalStateException("Cannot deactivate CommandSettings in current state"));
        }
        this.activated = false;
        LOGGER.info("CommandSettings were deactivated");
    }

    public String getPrefix(long guildId) {
        String prefix = this.prefixMap.get(guildId);
        return prefix != null ? prefix : this.defaultPrefix;
    }

    public String getPrefix() {
        return this.defaultPrefix;
    }

    public Set<Long> getBlacklistedChannels() {
        return Collections.unmodifiableSet(this.blacklistedChannels);
    }

    public boolean isBlacklisted(long channelId) {
        return this.blacklistedChannels.contains(channelId);
    }

    public Set<String> getLabelSet() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    public Set<String> getLabels(ICommand command) {
        return Collections.unmodifiableSet(this.commands.keySet().stream().filter(label -> this.commands.get(label).equals(command)).collect(Collectors.toSet()));
    }

    @Deprecated
    public Set<String> getHelpLabelSet() {
        return Collections.unmodifiableSet(this.helpLabels);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public Color getHelpColor() {
        return this.helpColor;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public boolean isLabelIgnoreCase() {
        return this.labelIgnoreCase;
    }

    public boolean isResetCooldown() {
        return this.resetCooldown;
    }

    public boolean botsMayExecute() {
        return this.botExecution;
    }

    public String toString() {
        return "CommandSettings{unknownCommandMessage=" + this.unknownCommandMessage + ", defaultPrefix='" + this.defaultPrefix + '\'' + ", cooldown=" + this.cooldown + ", helpColor=" + this.helpColor + ", blacklistedChannels=" + this.blacklistedChannels + ", prefixMap=" + this.prefixMap + ", commands=" + this.commands + ", activated=" + this.activated + ", labelIgnoreCase=" + this.labelIgnoreCase + ", resetCooldown=" + this.resetCooldown + ", botExecution=" + this.botExecution + '}';
    }

    protected Message getUnknownCommandMessage() {
        return this.unknownCommandMessage;
    }

    protected Map<String, ICommand> getCommands() {
        return this.commands;
    }
}

