/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.cronparser.domain.notation;

import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import uk.co.mruoc.cronparser.domain.TimeUnit;
import uk.co.mruoc.cronparser.domain.notation.InvalidNotationException;
import uk.co.mruoc.cronparser.domain.notation.NotationParser;
import uk.co.mruoc.cronparser.domain.notation.StringUtil;

public class RangeNotationParser
implements NotationParser {
    @Override
    public boolean appliesTo(String value) {
        String[] parts = RangeNotationParser.split(value);
        if (parts.length == 2) {
            return StringUtil.isInt(parts[0]) && StringUtil.isInt(parts[1]);
        }
        return false;
    }

    @Override
    public int[] toValues(String input, TimeUnit unit) {
        try {
            String[] parts = RangeNotationParser.split(input);
            int start = Integer.parseInt(parts[0]);
            int end = Integer.parseInt(parts[1]);
            unit.validate(start, end);
            return IntStream.rangeClosed(Math.min(start, end), Math.max(start, end)).toArray();
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new InvalidNotationException(input, e);
        }
    }

    private static String[] split(String value) {
        return StringUtils.split((String)value, (String)"-");
    }
}

