/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.provider;

import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ProviderConfigurationFileLine {
    private final @Nullable String providerBinaryName;
    private final @Nullable String comment;
    public static final ProviderConfigurationFileLine EMPTY = new ProviderConfigurationFileLine(null, null);

    public boolean hasProviderBinaryName() {
        return this.providerBinaryName != null;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public String toString() {
        if (this.hasProviderBinaryName()) {
            return this.hasComment() ? this.providerBinaryName + " #" + this.comment : this.providerBinaryName;
        }
        return this.hasComment() ? "#" + this.comment : "";
    }

    @NonNull
    public static ProviderConfigurationFileLine ofProviderBinaryName(@NonNull CharSequence providerBinaryName) {
        if (providerBinaryName == null) {
            throw new NullPointerException("providerBinaryName is marked non-null but is null");
        }
        if (providerBinaryName.length() == 0) {
            throw new IllegalArgumentException("Provider binary name cannot be empty");
        }
        return new ProviderConfigurationFileLine(providerBinaryName.toString(), null);
    }

    @NonNull
    public static ProviderConfigurationFileLine ofComment(@NonNull CharSequence comment) {
        if (comment == null) {
            throw new NullPointerException("comment is marked non-null but is null");
        }
        return new ProviderConfigurationFileLine(null, comment.toString());
    }

    @NonNull
    public static ProviderConfigurationFileLine ofProviderBinaryNameAndComment(@NonNull CharSequence providerName, @NonNull CharSequence comment) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (comment == null) {
            throw new NullPointerException("comment is marked non-null but is null");
        }
        return new ProviderConfigurationFileLine(providerName.toString(), comment.toString());
    }

    @NonNull
    public static ProviderConfigurationFileLine parse(@NonNull CharSequence text) throws IllegalArgumentException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        String line = text.toString();
        int commentIndex = line.indexOf(35);
        if (commentIndex >= 0) {
            String providerName = line.substring(0, commentIndex).trim();
            String comment = line.substring(commentIndex + 1);
            return providerName.isEmpty() ? ProviderConfigurationFileLine.ofComment(comment) : ProviderConfigurationFileLine.ofProviderBinaryNameAndComment(ProviderConfigurationFileLine.checkProviderName(providerName), comment);
        }
        String providerName = line.trim();
        return providerName.isEmpty() ? EMPTY : ProviderConfigurationFileLine.ofProviderBinaryName(ProviderConfigurationFileLine.checkProviderName(providerName));
    }

    private static String checkProviderName(String providerName) throws IllegalArgumentException {
        int start;
        if (providerName.indexOf(32) >= 0 || providerName.indexOf(9) >= 0) {
            throw new IllegalArgumentException("Illegal configuration-file syntax");
        }
        int cp = providerName.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            throw new IllegalArgumentException("Illegal provider-class name: " + providerName);
        }
        for (int i = start = Character.charCount(cp); i < providerName.length(); i += Character.charCount(cp)) {
            cp = providerName.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
            throw new IllegalArgumentException("Illegal provider-class name: " + providerName);
        }
        return providerName;
    }

    public static String getFileRelativeName(CharSequence serviceBinaryName) {
        return "META-INF/services/" + serviceBinaryName;
    }

    @Generated
    public @Nullable String getProviderBinaryName() {
        return this.providerBinaryName;
    }

    @Generated
    public @Nullable String getComment() {
        return this.comment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProviderConfigurationFileLine)) {
            return false;
        }
        ProviderConfigurationFileLine other = (ProviderConfigurationFileLine)o;
        String this$providerBinaryName = this.getProviderBinaryName();
        String other$providerBinaryName = other.getProviderBinaryName();
        if (this$providerBinaryName == null ? other$providerBinaryName != null : !this$providerBinaryName.equals(other$providerBinaryName)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $providerBinaryName = this.getProviderBinaryName();
        result = result * 59 + ($providerBinaryName == null ? 43 : $providerBinaryName.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    @Generated
    private ProviderConfigurationFileLine(@Nullable String providerBinaryName, @Nullable String comment) {
        this.providerBinaryName = providerBinaryName;
        this.comment = comment;
    }
}

