/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.nbbrd.service.ExtEnvironment;
import internal.nbbrd.service.ModuleInfoEntries;
import internal.nbbrd.service.com.squareup.javapoet.ClassName;
import internal.nbbrd.service.definition.Lifecycle;
import internal.nbbrd.service.definition.LoadDefinition;
import internal.nbbrd.service.definition.LoadFilter;
import internal.nbbrd.service.definition.LoadId;
import internal.nbbrd.service.definition.LoadSorter;
import internal.nbbrd.service.definition.TypeInstantiator;
import internal.nbbrd.service.definition.TypeWrapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import nbbrd.service.Quantifier;
import nbbrd.service.ServiceDefinition;

final class ServiceDefinitionChecker {
    private final ExtEnvironment env;
    private final PrimitiveType booleanType;
    private final TypeMirror runtimeExceptionType;

    public ServiceDefinitionChecker(ProcessingEnvironment env) {
        this.env = new ExtEnvironment(env);
        this.booleanType = env.getTypeUtils().getPrimitiveType(TypeKind.BOOLEAN);
        this.runtimeExceptionType = this.env.asTypeElement(RuntimeException.class).asType();
    }

    public void checkModuleInfo(List<LoadDefinition> definitions) {
        try {
            ModuleInfoEntries.parse(this.env.getFiler(), this.env.getElementUtils()).map(ModuleInfoEntries::getUsages).ifPresent(usages -> this.checkModuleInfoUsages((List<String>)usages, definitions));
        }
        catch (IOException ex) {
            String msg = ex.getClass().getSimpleName() + ": " + ex.getMessage();
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        }
    }

    private void checkModuleInfoUsages(List<String> usages, List<LoadDefinition> definitions) {
        definitions.stream().map(definition -> definition.getServiceType().toString()).filter(serviceType -> !usages.contains(serviceType)).map(this.env::asTypeElement).forEachOrdered(ref -> this.env.error((Element)ref, "Missing module-info directive 'uses " + ref + "'"));
    }

    public boolean checkFilter(LoadFilter filter) {
        Types types = this.env.getTypeUtils();
        ExecutableElement method = filter.getMethod();
        if (!filter.getServiceType().isPresent() || filter.getServiceType().get().getAnnotation(ServiceDefinition.class) == null) {
            this.env.error(method, "[RULE_F1] Filter method only applies to methods of a service");
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            this.env.error(method, "[RULE_F2] Filter method does not apply to static methods");
            return false;
        }
        if (!method.getParameters().isEmpty()) {
            this.env.error(method, "[RULE_F3] Filter method must have no-args");
            return false;
        }
        if (!types.isSameType(method.getReturnType(), this.booleanType)) {
            this.env.error(method, "[RULE_F4] Filter method must return boolean");
            return false;
        }
        if (this.hasCheckedExceptions(method)) {
            this.env.error(method, "[RULE_F5] Filter method must not throw checked exceptions");
            return false;
        }
        return true;
    }

    public boolean checkSorter(LoadSorter sorter) {
        ExecutableElement method = sorter.getMethod();
        if (!sorter.getServiceType().isPresent() || sorter.getServiceType().get().getAnnotation(ServiceDefinition.class) == null) {
            this.env.error(method, "[RULE_S1] Sorter method only applies to methods of a service");
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            this.env.error(method, "[RULE_S2] Sorter method does not apply to static methods");
            return false;
        }
        if (!method.getParameters().isEmpty()) {
            this.env.error(method, "[RULE_S3] Sorter method must have no-args");
            return false;
        }
        if (!sorter.getKeyType().isPresent()) {
            this.env.error(method, "[RULE_S4] Sorter method must return double, int, long or comparable");
            return false;
        }
        if (this.hasCheckedExceptions(method)) {
            this.env.error(method, "[RULE_S5] Sorter method must not throw checked exceptions");
            return false;
        }
        return true;
    }

    public boolean checkId(LoadId id) {
        Types types = this.env.getTypeUtils();
        ExecutableElement method = id.getMethod();
        if (!id.getServiceType().isPresent() || id.getServiceType().get().getAnnotation(ServiceDefinition.class) == null) {
            this.env.error(method, "[RULE_I1] Id method only applies to methods of a service");
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            this.env.error(method, "[RULE_I2] Id method does not apply to static methods");
            return false;
        }
        if (!method.getParameters().isEmpty()) {
            this.env.error(method, "[RULE_I3] Id method must have no-args");
            return false;
        }
        if (!types.isSameType(method.getReturnType(), this.env.asTypeElement(String.class).asType())) {
            this.env.error(method, "[RULE_I4] Id method must return String");
            return false;
        }
        if (this.hasCheckedExceptions(method)) {
            this.env.error(method, "[RULE_I6] Id method must not throw checked exceptions");
            return false;
        }
        if (!ServiceDefinitionChecker.isValidPattern(id.getPattern())) {
            this.env.error(method, "[RULE_I7] Id pattern must be valid");
            return false;
        }
        return true;
    }

    public boolean checkIds(Map<ClassName, List<LoadId>> idsByService) {
        for (Map.Entry<ClassName, List<LoadId>> o : idsByService.entrySet()) {
            if (o.getValue().size() <= 1) continue;
            this.env.error(o.getValue().get(1).getMethod(), "[RULE_I5] Id method must be unique");
            return false;
        }
        return true;
    }

    public boolean checkDefinition(LoadDefinition definition) {
        Types types = this.env.getTypeUtils();
        TypeElement service = this.env.asTypeElement(definition.getServiceType());
        if (!this.checkFallback(definition.getQuantifier(), definition.getFallback(), definition.isNoFallback() || ServiceDefinitionChecker.isSingleFallbackNotExpected(service), service, types)) {
            return false;
        }
        if (!this.checkWrapper(definition.getWrapper(), service, types)) {
            return false;
        }
        if (!this.checkPreprocessor(definition.getPreprocessor(), service, types)) {
            return false;
        }
        if (!this.checkBackend(definition.getBackend(), service, types)) {
            return false;
        }
        if (!this.checkCleaner(definition.getCleaner(), service, types)) {
            return false;
        }
        if (!this.checkMutability(definition, service)) {
            return false;
        }
        return this.checkBatch(definition, service);
    }

    private boolean checkFallback(Quantifier quantifier, Optional<TypeInstantiator> fallback, boolean noFallback, TypeElement service, Types types) {
        switch (quantifier) {
            case SINGLE: {
                if (fallback.isPresent() || noFallback) break;
                this.env.warn(service, String.format(Locale.ROOT, "Missing fallback for service '%1$s'", service));
                break;
            }
            case MULTIPLE: 
            case OPTIONAL: {
                if (!fallback.isPresent()) break;
                this.env.warn(service, String.format(Locale.ROOT, "Useless fallback for service '%1$s'", service));
            }
        }
        return !fallback.isPresent() || this.checkFallbackTypeHandler(fallback.get(), service, types);
    }

    private boolean checkFallbackTypeHandler(TypeInstantiator handler, TypeElement service, Types types) {
        if (!types.isAssignable(handler.getType(), types.erasure(service.asType()))) {
            this.env.error(service, String.format(Locale.ROOT, "Fallback '%1$s' doesn't extend nor implement service '%2$s'", handler.getType(), service));
            return false;
        }
        return this.checkInstanceFactories(service, handler.getType(), handler);
    }

    private boolean checkWrapper(Optional<TypeWrapper> wrapper, TypeElement service, Types types) {
        return !wrapper.isPresent() || this.checkWrapperTypeHandler(wrapper.get(), service, types);
    }

    private boolean checkWrapperTypeHandler(TypeWrapper handler, TypeElement service, Types types) {
        if (!types.isAssignable(handler.getType(), types.erasure(service.asType()))) {
            this.env.error(service, String.format(Locale.ROOT, "Wrapper '%1$s' doesn't extend nor implement service '%2$s'", handler.getType(), service));
            return false;
        }
        return this.checkWrapperFactories(service, handler.getType(), handler);
    }

    private boolean checkPreprocessor(Optional<TypeInstantiator> preprocessor, TypeElement service, Types types) {
        return !preprocessor.isPresent() || this.checkPreprocessorTypeHandler(preprocessor.get(), service, types);
    }

    private boolean checkPreprocessorTypeHandler(TypeInstantiator handler, TypeElement service, Types types) {
        TypeMirror expectedType = LoadDefinition.getPreprocessorType(this.env, service.asType());
        if (!types.isAssignable(handler.getType(), expectedType)) {
            this.env.error(service, String.format(Locale.ROOT, "Preprocessor '%1$s' doesn't extend nor implement '%2$s'", handler.getType(), expectedType));
            return false;
        }
        return this.checkInstanceFactories(service, handler.getType(), handler);
    }

    private boolean checkBackend(Optional<TypeInstantiator> backend, TypeElement service, Types types) {
        return !backend.isPresent() || this.checkBackendTypeHandler(backend.get(), service, types);
    }

    private boolean checkBackendTypeHandler(TypeInstantiator handler, TypeElement service, Types types) {
        TypeMirror expectedType = LoadDefinition.getBackendType(this.env, service.asType());
        if (!types.isAssignable(handler.getType(), expectedType)) {
            this.env.error(service, String.format(Locale.ROOT, "Backend '%1$s' doesn't extend nor implement '%2$s'", handler.getType(), expectedType));
            return false;
        }
        return this.checkInstanceFactories(service, handler.getType(), handler);
    }

    private boolean checkCleaner(Optional<TypeInstantiator> cleaner, TypeElement service, Types types) {
        return !cleaner.isPresent() || this.checkCleanerTypeHandler(cleaner.get(), service, types);
    }

    private boolean checkCleanerTypeHandler(TypeInstantiator handler, TypeElement service, Types types) {
        TypeMirror expectedType = LoadDefinition.getCleanerType(this.env, service.asType());
        if (!types.isAssignable(handler.getType(), expectedType)) {
            this.env.error(service, String.format(Locale.ROOT, "Cleaner '%1$s' doesn't extend nor implement '%2$s'", handler.getType(), expectedType));
            return false;
        }
        return this.checkInstanceFactories(service, handler.getType(), handler);
    }

    private boolean checkMutability(LoadDefinition definition, TypeElement service) {
        if (definition.getLifecycle() == Lifecycle.UNSAFE_MUTABLE) {
            this.env.warn(service, String.format(Locale.ROOT, "Thread-unsafe singleton for '%1$s'", service));
        }
        return true;
    }

    private boolean checkBatch(LoadDefinition definition, TypeElement service) {
        if (definition.getBatchType().isPresent()) {
            if (definition.isBatch()) {
                this.env.error(service, "Batch type cannot be used with batch property");
                return false;
            }
            TypeElement x = this.env.asTypeElement(definition.getBatchType().get());
            if (x.getKind() != ElementKind.INTERFACE && !x.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.env.error(service, "[RULE_B1] Batch type must be an interface or an abstract class");
                return false;
            }
            if (ElementFilter.methodsIn(x.getEnclosedElements()).stream().filter(this.batchMethodFilter(service)).count() != 1L) {
                this.env.error(service, "[RULE_B2] Batch method must be unique");
                return false;
            }
        }
        return true;
    }

    private Predicate<ExecutableElement> batchMethodFilter(TypeElement service) {
        DeclaredType streamType = this.env.getTypeUtils().getDeclaredType(this.env.asTypeElement(Stream.class), service.asType());
        return method -> method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && method.getParameters().isEmpty() && method.getSimpleName().contentEquals("getProviders") && this.env.getTypeUtils().isAssignable(method.getReturnType(), streamType) && !this.hasCheckedExceptions((ExecutableElement)method);
    }

    private boolean checkInstanceFactories(TypeElement annotatedElement, TypeMirror type, TypeInstantiator instance) {
        if (!instance.select().isPresent()) {
            this.env.error(annotatedElement, String.format(Locale.ROOT, "Don't know how to instantiate '%1$s'", type));
            return false;
        }
        return true;
    }

    private boolean checkWrapperFactories(TypeElement annotatedElement, TypeMirror type, TypeWrapper instance) {
        if (!instance.select().isPresent()) {
            this.env.error(annotatedElement, String.format(Locale.ROOT, "Don't know how to wrap '%1$s'", type));
            return false;
        }
        return true;
    }

    private boolean hasCheckedExceptions(ExecutableElement method) {
        return method.getThrownTypes().stream().anyMatch(type -> !this.env.getTypeUtils().isAssignable((TypeMirror)type, this.runtimeExceptionType));
    }

    private static boolean isValidPattern(String value) {
        try {
            Pattern.compile(value);
            return true;
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    private static boolean isSingleFallbackNotExpected(TypeElement service) {
        SuppressWarnings annotation = service.getAnnotation(SuppressWarnings.class);
        return annotation != null && Arrays.asList(annotation.value()).contains("SingleFallbackNotExpected");
    }
}

