/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.services.Base64Encoder;
import com.github.scribejava.core.utils.MapUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class OAuth10aService
extends OAuthService<OAuth1AccessToken> {
    private static final String VERSION = "1.0";
    private final DefaultApi10a api;

    public OAuth10aService(DefaultApi10a api, OAuthConfig config) {
        super(config);
        this.api = api;
    }

    public final OAuth1RequestToken getRequestToken() throws IOException, InterruptedException, ExecutionException {
        OAuthConfig config = this.getConfig();
        config.log("obtaining request token from " + this.api.getRequestTokenEndpoint());
        OAuthRequest request = this.prepareRequestTokenRequest();
        config.log("sending request...");
        Response response = this.execute(request);
        String body = response.getBody();
        config.log("response status code: " + response.getCode());
        config.log("response body: " + body);
        return this.api.getRequestTokenExtractor().extract(response);
    }

    public final Future<OAuth1RequestToken> getRequestTokenAsync() {
        return this.getRequestTokenAsync(null);
    }

    public final Future<OAuth1RequestToken> getRequestTokenAsync(OAuthAsyncRequestCallback<OAuth1RequestToken> callback) {
        OAuthConfig config = this.getConfig();
        config.log("async obtaining request token from " + this.api.getRequestTokenEndpoint());
        OAuthRequest request = this.prepareRequestTokenRequest();
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<OAuth1RequestToken>(){

            @Override
            public OAuth1RequestToken convert(Response response) throws IOException {
                return OAuth10aService.this.getApi().getRequestTokenExtractor().extract(response);
            }
        });
    }

    protected OAuthRequest prepareRequestTokenRequest() {
        OAuthRequest request = new OAuthRequest(this.api.getRequestTokenVerb(), this.api.getRequestTokenEndpoint());
        OAuthConfig config = this.getConfig();
        config.log("setting oauth_callback to " + config.getCallback());
        request.addOAuthParameter("oauth_callback", config.getCallback());
        this.addOAuthParams(request, "");
        this.appendSignature(request);
        return request;
    }

    private void addOAuthParams(OAuthRequest request, String tokenSecret) {
        OAuthConfig config = this.getConfig();
        request.addOAuthParameter("oauth_timestamp", this.api.getTimestampService().getTimestampInSeconds());
        request.addOAuthParameter("oauth_nonce", this.api.getTimestampService().getNonce());
        request.addOAuthParameter("oauth_consumer_key", config.getApiKey());
        request.addOAuthParameter("oauth_signature_method", this.api.getSignatureService().getSignatureMethod());
        request.addOAuthParameter("oauth_version", this.getVersion());
        String scope = config.getScope();
        if (scope != null) {
            request.addOAuthParameter("scope", scope);
        }
        request.addOAuthParameter("oauth_signature", this.getSignature(request, tokenSecret));
        config.log("appended additional OAuth parameters: " + MapUtils.toString(request.getOauthParameters()));
    }

    public final OAuth1AccessToken getAccessToken(OAuth1RequestToken requestToken, String oauthVerifier) throws IOException, InterruptedException, ExecutionException {
        this.getConfig().log("obtaining access token from " + this.api.getAccessTokenEndpoint());
        OAuthRequest request = this.prepareAccessTokenRequest(requestToken, oauthVerifier);
        Response response = this.execute(request);
        return this.api.getAccessTokenExtractor().extract(response);
    }

    public final Future<OAuth1AccessToken> getAccessTokenAsync(OAuth1RequestToken requestToken, String oauthVerifier) {
        return this.getAccessTokenAsync(requestToken, oauthVerifier, null);
    }

    public final Future<OAuth1AccessToken> getAccessTokenAsync(OAuth1RequestToken requestToken, String oauthVerifier, OAuthAsyncRequestCallback<OAuth1AccessToken> callback) {
        OAuthConfig config = this.getConfig();
        config.log("async obtaining access token from " + this.api.getAccessTokenEndpoint());
        OAuthRequest request = this.prepareAccessTokenRequest(requestToken, oauthVerifier);
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<OAuth1AccessToken>(){

            @Override
            public OAuth1AccessToken convert(Response response) throws IOException {
                return OAuth10aService.this.getApi().getAccessTokenExtractor().extract(response);
            }
        });
    }

    protected OAuthRequest prepareAccessTokenRequest(OAuth1RequestToken requestToken, String oauthVerifier) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        OAuthConfig config = this.getConfig();
        request.addOAuthParameter("oauth_token", requestToken.getToken());
        request.addOAuthParameter("oauth_verifier", oauthVerifier);
        config.log("setting token to: " + requestToken + " and verifier to: " + oauthVerifier);
        this.addOAuthParams(request, requestToken.getTokenSecret());
        this.appendSignature(request);
        return request;
    }

    @Override
    public void signRequest(OAuth1AccessToken token, OAuthRequest request) {
        OAuthConfig config = this.getConfig();
        config.log("signing request: " + request.getCompleteUrl());
        if (!token.isEmpty() || this.api.isEmptyOAuthTokenParamIsRequired()) {
            request.addOAuthParameter("oauth_token", token.getToken());
        }
        config.log("setting token to: " + token);
        this.addOAuthParams(request, token.getTokenSecret());
        this.appendSignature(request);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public String getAuthorizationUrl(OAuth1RequestToken requestToken) {
        return this.api.getAuthorizationUrl(requestToken);
    }

    private String getSignature(OAuthRequest request, String tokenSecret) {
        OAuthConfig config = this.getConfig();
        config.log("generating signature...");
        config.log("using base64 encoder: " + Base64Encoder.type());
        String baseString = this.api.getBaseStringExtractor().extract(request);
        String signature = this.api.getSignatureService().getSignature(baseString, config.getApiSecret(), tokenSecret);
        config.log("base string is: " + baseString);
        config.log("signature is: " + signature);
        return signature;
    }

    private void appendSignature(OAuthRequest request) {
        OAuthConfig config = this.getConfig();
        switch (config.getSignatureType()) {
            case Header: {
                config.log("using Http Header signature");
                String oauthHeader = this.api.getHeaderExtractor().extract(request);
                request.addHeader("Authorization", oauthHeader);
                break;
            }
            case QueryString: {
                config.log("using Querystring signature");
                for (Map.Entry<String, String> entry : request.getOauthParameters().entrySet()) {
                    request.addQuerystringParameter(entry.getKey(), entry.getValue());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown new Signature Type '" + (Object)((Object)config.getSignatureType()) + "'.");
            }
        }
    }

    public DefaultApi10a getApi() {
        return this.api;
    }
}

