/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.OAuth1AccessTokenExtractor;
import com.github.scribejava.core.model.OAuth1Token;
import com.github.scribejava.core.model.Response;
import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuth1AccessTokenExtractorTest {
    private OAuth1AccessTokenExtractor extractor;

    @Before
    public void setUp() {
        this.extractor = OAuth1AccessTokenExtractor.instance();
    }

    @Test
    public void shouldExtractTokenFromOAuthStandardResponse() throws IOException {
        String response = "oauth_token=hh5s93j4hdidpola&oauth_token_secret=hdhd0244k9j7ao03";
        OAuth1Token extracted = this.extractor.extract(OAuth1AccessTokenExtractorTest.ok("oauth_token=hh5s93j4hdidpola&oauth_token_secret=hdhd0244k9j7ao03"));
        Assert.assertEquals((Object)"hh5s93j4hdidpola", (Object)extracted.getToken());
        Assert.assertEquals((Object)"hdhd0244k9j7ao03", (Object)extracted.getTokenSecret());
    }

    @Test
    public void shouldExtractTokenFromInvertedOAuthStandardResponse() throws IOException {
        String response = "oauth_token_secret=hh5s93j4hdidpola&oauth_token=hdhd0244k9j7ao03";
        OAuth1Token extracted = this.extractor.extract(OAuth1AccessTokenExtractorTest.ok("oauth_token_secret=hh5s93j4hdidpola&oauth_token=hdhd0244k9j7ao03"));
        Assert.assertEquals((Object)"hh5s93j4hdidpola", (Object)extracted.getTokenSecret());
        Assert.assertEquals((Object)"hdhd0244k9j7ao03", (Object)extracted.getToken());
    }

    @Test
    public void shouldExtractTokenFromResponseWithCallbackConfirmed() throws IOException {
        String response = "oauth_token=hh5s93j4hdidpola&oauth_token_secret=hdhd0244k9j7ao03&callback_confirmed=true";
        OAuth1Token extracted = this.extractor.extract(OAuth1AccessTokenExtractorTest.ok("oauth_token=hh5s93j4hdidpola&oauth_token_secret=hdhd0244k9j7ao03&callback_confirmed=true"));
        Assert.assertEquals((Object)"hh5s93j4hdidpola", (Object)extracted.getToken());
        Assert.assertEquals((Object)"hdhd0244k9j7ao03", (Object)extracted.getTokenSecret());
    }

    @Test
    public void shouldExtractTokenWithEmptySecret() throws IOException {
        String response = "oauth_token=hh5s93j4hdidpola&oauth_token_secret=";
        OAuth1Token extracted = this.extractor.extract(OAuth1AccessTokenExtractorTest.ok("oauth_token=hh5s93j4hdidpola&oauth_token_secret="));
        Assert.assertEquals((Object)"hh5s93j4hdidpola", (Object)extracted.getToken());
        Assert.assertEquals((Object)"", (Object)extracted.getTokenSecret());
    }

    @Test(expected=OAuthException.class)
    public void shouldThrowExceptionIfTokenIsAbsent() throws IOException {
        String response = "oauth_secret=hh5s93j4hdidpola&callback_confirmed=true";
        this.extractor.extract(OAuth1AccessTokenExtractorTest.ok("oauth_secret=hh5s93j4hdidpola&callback_confirmed=true"));
    }

    @Test(expected=OAuthException.class)
    public void shouldThrowExceptionIfSecretIsAbsent() throws IOException {
        String response = "oauth_token=hh5s93j4hdidpola&callback_confirmed=true";
        this.extractor.extract(OAuth1AccessTokenExtractorTest.ok("oauth_token=hh5s93j4hdidpola&callback_confirmed=true"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfResponseIsNull() throws IOException {
        this.extractor.extract(OAuth1AccessTokenExtractorTest.ok(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfResponseIsEmptyString() throws IOException {
        String response = "";
        this.extractor.extract(OAuth1AccessTokenExtractorTest.ok(""));
    }

    private static Response ok(String body) {
        return new Response(200, null, Collections.emptyMap(), body);
    }
}

