/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.java8.Base64;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2Authorization;
import com.github.scribejava.core.oauth.OAuth20ApiUnit;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class OAuth20ServiceTest {
    private final Base64.Encoder base64Encoder = Base64.getEncoder();

    @Test
    public void shouldProduceCorrectRequestSync() throws IOException, InterruptedException, ExecutionException {
        OAuth20Service service = new ServiceBuilder("your_api_key").apiSecret("your_api_secret").build((DefaultApi20)new OAuth20ApiUnit());
        OAuth2AccessToken token = service.getAccessTokenPasswordGrant("user1", "password1");
        Gson json = new Gson();
        Assert.assertNotNull((Object)token);
        Map map = (Map)json.fromJson(token.getRawResponse(), new TypeTokenImpl().getType());
        Assert.assertEquals((Object)"ae82980abab675c646a070686d5558ad", map.get("access_token"));
        Assert.assertEquals((Object)"3600", map.get("expires_in"));
        String authorize = this.base64Encoder.encodeToString(String.format("%s:%s", service.getApiKey(), service.getApiSecret()).getBytes(Charset.forName("UTF-8")));
        Assert.assertEquals((Object)("Basic " + authorize), map.get("Authorization"));
        Assert.assertEquals((Object)"user1", map.get("query-username"));
        Assert.assertEquals((Object)"password1", map.get("query-password"));
        Assert.assertEquals((Object)"password", map.get("query-grant_type"));
    }

    @Test
    public void shouldProduceCorrectRequestAsync() throws ExecutionException, InterruptedException {
        OAuth20Service service = new ServiceBuilder("your_api_key").apiSecret("your_api_secret").build((DefaultApi20)new OAuth20ApiUnit());
        OAuth2AccessToken token = (OAuth2AccessToken)service.getAccessTokenPasswordGrantAsync("user1", "password1").get();
        Gson json = new Gson();
        Assert.assertNotNull((Object)token);
        Map map = (Map)json.fromJson(token.getRawResponse(), new TypeTokenImpl().getType());
        Assert.assertEquals((Object)"ae82980abab675c646a070686d5558ad", map.get("access_token"));
        Assert.assertEquals((Object)"3600", map.get("expires_in"));
        String authorize = this.base64Encoder.encodeToString(String.format("%s:%s", service.getApiKey(), service.getApiSecret()).getBytes(Charset.forName("UTF-8")));
        Assert.assertEquals((Object)("Basic " + authorize), map.get("Authorization"));
        Assert.assertEquals((Object)"user1", map.get("query-username"));
        Assert.assertEquals((Object)"password1", map.get("query-password"));
        Assert.assertEquals((Object)"password", map.get("query-grant_type"));
    }

    @Test
    public void testOAuthExtractAuthorization() {
        OAuth20Service service = new ServiceBuilder("your_api_key").apiSecret("your_api_secret").build((DefaultApi20)new OAuth20ApiUnit());
        OAuth2Authorization authorization = service.extractAuthorization("https://cl.ex.com/cb?code=SplxlOB&state=xyz");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals((Object)"xyz", (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?state=xyz&code=SplxlOB");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals((Object)"xyz", (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?key=value&state=xyz&code=SplxlOB");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals((Object)"xyz", (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?state=xyz&code=SplxlOB&key=value&");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals((Object)"xyz", (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?code=SplxlOB&state=");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?code=SplxlOB");
        Assert.assertEquals((Object)"SplxlOB", (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?code=");
        Assert.assertEquals(null, (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?code");
        Assert.assertEquals(null, (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb?");
        Assert.assertEquals(null, (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
        authorization = service.extractAuthorization("https://cl.ex.com/cb");
        Assert.assertEquals(null, (Object)authorization.getCode());
        Assert.assertEquals(null, (Object)authorization.getState());
    }

    private static class TypeTokenImpl
    extends TypeToken<Map<String, String>> {
        private TypeTokenImpl() {
        }
    }
}

