/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.httpclient.jdk;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.httpclient.jdk.JDKHttpFuture;
import com.github.scribejava.core.httpclient.multipart.BodyPartPayload;
import com.github.scribejava.core.httpclient.multipart.ByteArrayBodyPartPayload;
import com.github.scribejava.core.httpclient.multipart.MultipartPayload;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class JDKHttpClient
implements HttpClient {
    private final JDKHttpClientConfig config;

    public JDKHttpClient() {
        this(JDKHttpClientConfig.defaultConfig());
    }

    public JDKHttpClient(JDKHttpClientConfig clientConfig) {
        this.config = clientConfig;
    }

    @Override
    public void close() {
    }

    @Override
    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.BYTE_ARRAY, bodyContents, callback, converter);
    }

    @Override
    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, MultipartPayload bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.MULTIPART, bodyContents, callback, converter);
    }

    @Override
    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.STRING, bodyContents, callback, converter);
    }

    @Override
    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        throw new UnsupportedOperationException("JDKHttpClient does not support File payload for the moment");
    }

    private <T> Future<T> doExecuteAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, BodyType bodyType, Object bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        try {
            Response t;
            Response response = this.doExecute(userAgent, headers, httpVerb, completeUrl, bodyType, bodyContents);
            Response response2 = t = converter == null ? response : converter.convert(response);
            if (callback != null) {
                callback.onCompleted(t);
            }
            return new JDKHttpFuture<Response>(t);
        }
        catch (IOException | RuntimeException e) {
            if (callback != null) {
                callback.onThrowable(e);
            }
            return new JDKHttpFuture(e);
        }
    }

    @Override
    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents) throws InterruptedException, ExecutionException, IOException {
        return this.doExecute(userAgent, headers, httpVerb, completeUrl, BodyType.BYTE_ARRAY, bodyContents);
    }

    @Override
    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, MultipartPayload multipartPayloads) throws InterruptedException, ExecutionException, IOException {
        return this.doExecute(userAgent, headers, httpVerb, completeUrl, BodyType.MULTIPART, multipartPayloads);
    }

    @Override
    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents) throws InterruptedException, ExecutionException, IOException {
        return this.doExecute(userAgent, headers, httpVerb, completeUrl, BodyType.STRING, bodyContents);
    }

    @Override
    public Response execute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents) throws InterruptedException, ExecutionException, IOException {
        throw new UnsupportedOperationException("JDKHttpClient does not support File payload for the moment");
    }

    private Response doExecute(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, BodyType bodyType, Object bodyContents) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(completeUrl).openConnection();
        connection.setInstanceFollowRedirects(this.config.isFollowRedirects());
        connection.setRequestMethod(httpVerb.name());
        if (this.config.getConnectTimeout() != null) {
            connection.setConnectTimeout(this.config.getConnectTimeout());
        }
        if (this.config.getReadTimeout() != null) {
            connection.setReadTimeout(this.config.getReadTimeout());
        }
        JDKHttpClient.addHeaders(connection, headers, userAgent);
        if (httpVerb.isPermitBody()) {
            bodyType.setBody(connection, bodyContents, httpVerb.isRequiresBody());
        }
        try {
            connection.connect();
            int responseCode = connection.getResponseCode();
            return new Response(responseCode, connection.getResponseMessage(), JDKHttpClient.parseHeaders(connection), responseCode >= 200 && responseCode < 400 ? connection.getInputStream() : connection.getErrorStream());
        }
        catch (UnknownHostException e) {
            throw new OAuthException("The IP address of a host could not be determined.", e);
        }
    }

    private static Map<String, String> parseHeaders(HttpURLConnection conn) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> headerField : conn.getHeaderFields().entrySet()) {
            String key = headerField.getKey();
            String value = headerField.getValue().get(0);
            if ("Content-Encoding".equalsIgnoreCase(key)) {
                headers.put("Content-Encoding", value);
                continue;
            }
            headers.put(key, value);
        }
        return headers;
    }

    private static void addHeaders(HttpURLConnection connection, Map<String, String> headers, String userAgent) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        if (userAgent != null) {
            connection.setRequestProperty("User-Agent", userAgent);
        }
    }

    private static void addBody(HttpURLConnection connection, byte[] content, boolean requiresBody) throws IOException {
        int contentLength = content.length;
        if (requiresBody || contentLength > 0) {
            JDKHttpClient.prepareConnectionForBodyAndGetOutputStream(connection, contentLength).write(content);
        }
    }

    private static void addBody(HttpURLConnection connection, MultipartPayload multipartPayload, boolean requiresBody) throws IOException {
        ByteArrayOutputStream os;
        for (Map.Entry<String, String> header : multipartPayload.getHeaders().entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        if (requiresBody && (os = JDKHttpClient.getPayload(multipartPayload)).size() > 0) {
            os.writeTo(JDKHttpClient.prepareConnectionForBodyAndGetOutputStream(connection, os.size()));
        }
    }

    static ByteArrayOutputStream getPayload(MultipartPayload multipartPayload) throws IOException {
        List<BodyPartPayload> bodyParts;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String preamble = multipartPayload.getPreamble();
        if (preamble != null) {
            os.write(preamble.getBytes());
        }
        if (!(bodyParts = multipartPayload.getBodyParts()).isEmpty()) {
            String boundary = multipartPayload.getBoundary();
            byte[] startBoundary = ("\r\n--" + boundary + "\r\n").getBytes();
            for (BodyPartPayload bodyPart : bodyParts) {
                os.write(startBoundary);
                Map<String, String> bodyPartHeaders = bodyPart.getHeaders();
                if (bodyPartHeaders != null) {
                    for (Map.Entry<String, String> header : bodyPartHeaders.entrySet()) {
                        os.write((header.getKey() + ": " + header.getValue() + "\r\n").getBytes());
                    }
                }
                if (bodyPart instanceof MultipartPayload) {
                    JDKHttpClient.getPayload((MultipartPayload)bodyPart).writeTo(os);
                    continue;
                }
                if (bodyPart instanceof ByteArrayBodyPartPayload) {
                    os.write("\r\n".getBytes());
                    os.write(((ByteArrayBodyPartPayload)bodyPart).getPayload());
                    continue;
                }
                throw new AssertionError(bodyPart.getClass());
            }
            os.write(("\r\n--" + boundary + "--\r\n").getBytes());
            String epilogue = multipartPayload.getEpilogue();
            if (epilogue != null) {
                os.write((epilogue + "\r\n").getBytes());
            }
        }
        return os;
    }

    private static OutputStream prepareConnectionForBodyAndGetOutputStream(HttpURLConnection connection, int contentLength) throws IOException {
        connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
        if (connection.getRequestProperty("Content-Type") == null) {
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        connection.setDoOutput(true);
        return connection.getOutputStream();
    }

    private static enum BodyType {
        BYTE_ARRAY{

            @Override
            void setBody(HttpURLConnection connection, Object bodyContents, boolean requiresBody) throws IOException {
                JDKHttpClient.addBody(connection, (byte[])bodyContents, requiresBody);
            }
        }
        ,
        MULTIPART{

            @Override
            void setBody(HttpURLConnection connection, Object bodyContents, boolean requiresBody) throws IOException {
                JDKHttpClient.addBody(connection, (MultipartPayload)bodyContents, requiresBody);
            }
        }
        ,
        STRING{

            @Override
            void setBody(HttpURLConnection connection, Object bodyContents, boolean requiresBody) throws IOException {
                JDKHttpClient.addBody(connection, ((String)bodyContents).getBytes(), requiresBody);
            }
        };


        abstract void setBody(HttpURLConnection var1, Object var2, boolean var3) throws IOException;
    }
}

