/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.services;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.services.HMACSha1SignatureService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HMACSha1SignatureServiceTest {
    private HMACSha1SignatureService service;

    @Before
    public void setUp() {
        this.service = new HMACSha1SignatureService();
    }

    @Test
    public void shouldReturnSignatureMethodString() {
        String expected = "HMAC-SHA1";
        Assert.assertEquals((Object)"HMAC-SHA1", (Object)this.service.getSignatureMethod());
    }

    @Test
    public void shouldReturnSignature() {
        String apiSecret = "api secret";
        String tokenSecret = "token secret";
        String baseString = "base string";
        String signature = "uGymw2KHOTWI699YEaoi5xyLT50=";
        Assert.assertEquals((Object)"uGymw2KHOTWI699YEaoi5xyLT50=", (Object)this.service.getSignature("base string", "api secret", "token secret"));
    }

    @Test(expected=OAuthException.class)
    public void shouldThrowExceptionIfBaseStringIsNull() {
        this.service.getSignature(null, "apiSecret", "tokenSecret");
    }

    @Test(expected=OAuthException.class)
    public void shouldThrowExceptionIfBaseStringIsEmpty() {
        this.service.getSignature("  ", "apiSecret", "tokenSecret");
    }

    @Test(expected=OAuthException.class)
    public void shouldThrowExceptionIfApiSecretIsNull() {
        this.service.getSignature("base string", null, "tokenSecret");
    }

    public void shouldNotThrowExceptionIfApiSecretIsEmpty() {
        this.service.getSignature("base string", "  ", "tokenSecret");
    }
}

