/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.ParameterList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class ParameterListTest {
    private ParameterList params;

    @Before
    public void setUp() {
        this.params = new ParameterList();
    }

    public void shouldThrowExceptionWhenAppendingNullMapToQuerystring() {
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                ParameterListTest.this.params.appendTo(null);
            }
        });
    }

    @Test
    public void shouldAppendNothingToQuerystringIfGivenEmptyMap() {
        String url = "http://www.example.com";
        Assert.assertEquals((Object)"http://www.example.com", (Object)this.params.appendTo("http://www.example.com"));
    }

    @Test
    public void shouldAppendParametersToSimpleUrl() {
        String url = "http://www.example.com";
        String expectedUrl = "http://www.example.com?param1=value1&param2=value%20with%20spaces";
        this.params.add("param1", "value1");
        this.params.add("param2", "value with spaces");
        url = this.params.appendTo(url);
        Assert.assertEquals((Object)"http://www.example.com?param1=value1&param2=value%20with%20spaces", (Object)url);
    }

    @Test
    public void shouldAppendParametersToUrlWithQuerystring() {
        String url = "http://www.example.com?already=present";
        String expectedUrl = "http://www.example.com?already=present&param1=value1&param2=value%20with%20spaces";
        this.params.add("param1", "value1");
        this.params.add("param2", "value with spaces");
        url = this.params.appendTo(url);
        Assert.assertEquals((Object)"http://www.example.com?already=present&param1=value1&param2=value%20with%20spaces", (Object)url);
    }

    @Test
    public void shouldProperlySortParameters() {
        this.params.add("param1", "v1");
        this.params.add("param6", "v2");
        this.params.add("a_param", "v3");
        this.params.add("param2", "v4");
        Assert.assertEquals((Object)"a_param=v3&param1=v1&param2=v4&param6=v2", (Object)this.params.sort().asFormUrlEncodedString());
    }

    @Test
    public void shouldProperlySortParametersWithTheSameName() {
        this.params.add("param1", "v1");
        this.params.add("param6", "v2");
        this.params.add("a_param", "v3");
        this.params.add("param1", "v4");
        Assert.assertEquals((Object)"a_param=v3&param1=v1&param1=v4&param6=v2", (Object)this.params.sort().asFormUrlEncodedString());
    }

    @Test
    public void shouldNotModifyTheOriginalParameterList() {
        this.params.add("param1", "v1");
        this.params.add("param6", "v2");
        Assert.assertNotSame((Object)this.params, (Object)this.params.sort());
    }
}

