/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.utils;

import com.github.scribejava.core.utils.Preconditions;
import org.junit.Assert;
import org.junit.function.ThrowingRunnable;

public class PreconditionsTest {
    private static final String ERROR_MSG = "";

    public void shouldThrowExceptionForNullObjects() {
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                Preconditions.checkNotNull(null, (String)PreconditionsTest.ERROR_MSG);
            }
        });
    }

    public void shouldThrowExceptionForNullStrings() {
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                Preconditions.checkEmptyString(null, (String)PreconditionsTest.ERROR_MSG);
            }
        });
    }

    public void shouldThrowExceptionForEmptyStrings() {
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                Preconditions.checkEmptyString((String)PreconditionsTest.ERROR_MSG, (String)PreconditionsTest.ERROR_MSG);
            }
        });
    }

    public void shouldThrowExceptionForSpacesOnlyStrings() {
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                Preconditions.checkEmptyString((String)"               ", (String)PreconditionsTest.ERROR_MSG);
            }
        });
    }
}

