/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.armeria;

import com.github.scribejava.core.httpclient.AbstractAsyncOnlyHttpClient;
import com.github.scribejava.core.httpclient.multipart.MultipartPayload;
import com.github.scribejava.core.httpclient.multipart.MultipartUtils;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.httpclient.armeria.ArmeriaHttpClientConfig;
import com.github.scribejava.httpclient.armeria.ArmeriaWebClientBuilder;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class ArmeriaHttpClient
extends AbstractAsyncOnlyHttpClient {
    private final ArmeriaWebClientBuilder clientBuilder;
    private final Map<String, WebClient> httpClients = new HashMap<String, WebClient>();
    private final ReentrantReadWriteLock httpClientsLock = new ReentrantReadWriteLock();

    public ArmeriaHttpClient() {
        this(ArmeriaHttpClientConfig.defaultConfig());
    }

    public ArmeriaHttpClient(ArmeriaHttpClientConfig config) {
        this.clientBuilder = config.createClientBuilder();
    }

    public void close() {
        ReentrantReadWriteLock.WriteLock writeLock = this.httpClientsLock.writeLock();
        writeLock.lock();
        try {
            this.httpClients.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, new BytesBody(bodyContents), callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, MultipartPayload bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, new MultipartBody(bodyContents), callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, new StringBody(bodyContents), callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, new FileBody(bodyContents), callback, converter);
    }

    private <T> CompletableFuture<T> doExecuteAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, Supplier<HttpData> contentSupplier, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        HttpResponse response;
        URI uri = URI.create(completeUrl);
        String path = ArmeriaHttpClient.getServicePath(uri);
        WebClient client = this.getClient(uri);
        RequestHeadersBuilder headersBuilder = RequestHeaders.of((HttpMethod)ArmeriaHttpClient.getHttpMethod(httpVerb), (String)path).toBuilder();
        headersBuilder.add(headers.entrySet());
        if (userAgent != null) {
            headersBuilder.add((CharSequence)"User-Agent", userAgent);
        }
        if (httpVerb.isPermitBody()) {
            HttpData contents = contentSupplier.get();
            if (httpVerb.isRequiresBody() && contents == null) {
                throw new IllegalArgumentException("Contents missing for request method " + httpVerb.name());
            }
            if (headersBuilder.contentType() == null) {
                headersBuilder.contentType(MediaType.FORM_DATA);
            }
            response = contents != null ? client.execute(headersBuilder.build(), contents) : client.execute(headersBuilder.build());
        } else {
            response = client.execute(headersBuilder.build());
        }
        return ((CompletableFuture)response.aggregate().thenApply(aggregatedResponse -> this.whenResponseComplete(callback, converter, (AggregatedHttpResponse)aggregatedResponse))).exceptionally(throwable -> this.completeExceptionally(callback, (Throwable)throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebClient getClient(URI uri) {
        WebClient client;
        String endpoint = ArmeriaHttpClient.getEndPoint(uri);
        ReentrantReadWriteLock.ReadLock readLock = this.httpClientsLock.readLock();
        readLock.lock();
        try {
            client = this.httpClients.get(endpoint);
        }
        finally {
            readLock.unlock();
        }
        if (client != null) {
            return client;
        }
        client = this.clientBuilder.newWebClient(Objects.requireNonNull(uri.getScheme(), "scheme"), Objects.requireNonNull(uri.getAuthority(), "authority"));
        ReentrantReadWriteLock.WriteLock writeLock = this.httpClientsLock.writeLock();
        writeLock.lock();
        try {
            if (!this.httpClients.containsKey(endpoint)) {
                this.httpClients.put(endpoint, client);
                WebClient webClient = client;
                return webClient;
            }
            WebClient webClient = this.httpClients.get(endpoint);
            return webClient;
        }
        finally {
            writeLock.unlock();
        }
    }

    private static String getEndPoint(URI uri) {
        return Objects.requireNonNull(uri.getScheme(), "scheme") + "://" + Objects.requireNonNull(uri.getAuthority(), "authority");
    }

    private static String getServicePath(URI uri) {
        String fragment;
        StringBuilder builder = new StringBuilder().append(Objects.requireNonNull(uri.getPath(), "path"));
        String query = uri.getQuery();
        if (query != null) {
            builder.append('?').append(query);
        }
        if ((fragment = uri.getFragment()) != null) {
            builder.append('#').append(fragment);
        }
        return builder.toString();
    }

    private static HttpMethod getHttpMethod(Verb httpVerb) {
        switch (httpVerb) {
            case GET: {
                return HttpMethod.GET;
            }
            case POST: {
                return HttpMethod.POST;
            }
            case PUT: {
                return HttpMethod.PUT;
            }
            case DELETE: {
                return HttpMethod.DELETE;
            }
            case HEAD: {
                return HttpMethod.HEAD;
            }
            case OPTIONS: {
                return HttpMethod.OPTIONS;
            }
            case TRACE: {
                return HttpMethod.TRACE;
            }
            case PATCH: {
                return HttpMethod.PATCH;
            }
        }
        throw new IllegalArgumentException("message build error: unsupported HTTP method: " + httpVerb.name());
    }

    private Response convertResponse(AggregatedHttpResponse aggregatedResponse) {
        HashMap headersMap = new HashMap();
        aggregatedResponse.headers().forEach((header, value) -> headersMap.put(header.toString(), value));
        HttpStatus status = aggregatedResponse.status();
        InputStream inputStream = aggregatedResponse.content().toInputStream();
        return new Response(status.code(), status.reasonPhrase(), headersMap, inputStream, new Closeable[]{inputStream});
    }

    private <T> T whenResponseComplete(OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter, AggregatedHttpResponse aggregatedResponse) {
        Response response = this.convertResponse(aggregatedResponse);
        try {
            Response t;
            Object object = t = converter == null ? response : converter.convert(response);
            if (callback != null) {
                callback.onCompleted((Object)t);
            }
            return (T)t;
        }
        catch (IOException | RuntimeException e) {
            return this.completeExceptionally(callback, e);
        }
    }

    private <T> T completeExceptionally(OAuthAsyncRequestCallback<T> callback, Throwable throwable) {
        if (callback != null) {
            callback.onThrowable(throwable);
        }
        return null;
    }

    private static class BytesBody
    implements Supplier<HttpData> {
        private final byte[] bodyContents;

        BytesBody(byte[] bodyContents) {
            this.bodyContents = bodyContents;
        }

        @Override
        public HttpData get() {
            return this.bodyContents != null ? HttpData.wrap((byte[])this.bodyContents) : null;
        }
    }

    private static class MultipartBody
    implements Supplier<HttpData> {
        private final MultipartPayload bodyContents;

        MultipartBody(MultipartPayload bodyContents) {
            this.bodyContents = bodyContents;
        }

        @Override
        public HttpData get() {
            try {
                return this.bodyContents != null ? HttpData.wrap((byte[])MultipartUtils.getPayload((MultipartPayload)this.bodyContents).toByteArray()) : null;
            }
            catch (IOException ioE) {
                throw new RuntimeException(ioE);
            }
        }
    }

    private static class StringBody
    implements Supplier<HttpData> {
        private final String bodyContents;

        StringBody(String bodyContents) {
            this.bodyContents = bodyContents;
        }

        @Override
        public HttpData get() {
            return this.bodyContents != null ? HttpData.ofUtf8((String)this.bodyContents) : null;
        }
    }

    private static class FileBody
    implements Supplier<HttpData> {
        private final File bodyContents;

        FileBody(File bodyContents) {
            this.bodyContents = bodyContents;
        }

        @Override
        public HttpData get() {
            try {
                return this.bodyContents != null ? HttpData.wrap((byte[])Files.readAllBytes(this.bodyContents.toPath())) : null;
            }
            catch (IOException ioE) {
                throw new RuntimeException(ioE);
            }
        }
    }
}

