/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallmenu.fun.fun;

import com.github.smallmenu.fun.Fun;
import java.util.concurrent.ThreadLocalRandom;

public class RandomFun {
    public static final String RANDOM_CHAR_POOL = "abcdefghijklmnopqrstuvwxyz";
    public static final String RANDOM_NUM_POOL = "0123456789";
    public static final String RANDOM_CHAR_NUM_POOL = "abcdefghijklmnopqrstuvwxyz0123456789";

    private RandomFun() {
        throw new AssertionError();
    }

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static int randomInt() {
        return RandomFun.getRandom().nextInt();
    }

    public static int randomInt(int min, int max) {
        return RandomFun.getRandom().nextInt(min, max);
    }

    public static int randomInt(int max) {
        return RandomFun.getRandom().nextInt(max);
    }

    public static long randomLong(long min, long max) {
        return RandomFun.getRandom().nextLong(min, max);
    }

    public static long randomLong() {
        return RandomFun.getRandom().nextLong();
    }

    public static long randomLong(long max) {
        return RandomFun.getRandom().nextLong(max);
    }

    public static String randomString(int length) {
        return RandomFun.randomString(RANDOM_CHAR_NUM_POOL, length);
    }

    public static String randomStringExcept(int length, String ... excepts) {
        String pool = RANDOM_CHAR_NUM_POOL;
        pool = Fun.removeAny((CharSequence)pool, excepts);
        return RandomFun.randomString(pool, length);
    }

    public static String randomStringNumber(int length) {
        return RandomFun.randomString(RANDOM_NUM_POOL, length);
    }

    public static String randomStringChar(int length) {
        return RandomFun.randomString(RANDOM_CHAR_POOL, length);
    }

    public static String randomString(String baseString, int length) {
        if (Fun.empty(baseString)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomFun.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }
}

