/*
 * Decompiled with CFR 0.152.
 */
package org.redmine.ta.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.redmine.ta.internal.RedmineDateHandler;

public class RedmineLongDateHandler
extends RedmineDateHandler {
    private static final String FORMAT_REDMINE_1_1 = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final int SHIFT = 3;

    @Override
    public Date getDate(String str) throws ParseException {
        String converted = this.convertToRFC822Format(str);
        Date date = formatter.parse(converted);
        return date;
    }

    private String convertToRFC822Format(String str) {
        StringBuffer b = new StringBuffer();
        b.append(str.substring(0, str.length() - 3));
        b.append(str.substring(str.length() - 3 + 1));
        return b.toString();
    }

    private String convertToRedmine11Format(String str) {
        StringBuffer b = new StringBuffer();
        b.append(str.substring(0, str.length() - 3 + 1));
        b.append(":");
        b.append(str.substring(str.length() - 3 + 1));
        return b.toString();
    }

    @Override
    public String getString(Date date) {
        String rfcFormat = formatter.format(date);
        String redmineFormat = this.convertToRedmine11Format(rfcFormat);
        return redmineFormat;
    }

    public static void main(String[] args) throws ParseException {
        Date d = new Date();
        RedmineLongDateHandler h = new RedmineLongDateHandler();
        System.out.println(h.getString(d));
    }
}

