/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.annotation.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.stereotype.Component;

@Component
public class SpringContextBean {
    private static Logger logger = LoggerFactory.getLogger(SpringContextBean.class);
    private static ApplicationContext applicationContext;

    @Autowired
    public SpringContextBean(ApplicationContext applicationContext) {
        SpringContextBean.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static void setApplicationContext(ApplicationContext applicationContext) {
        SpringContextBean.applicationContext = applicationContext;
    }

    public static GraphQlClient getGraphQlClient(String graphQLSchema, RequestType requestType) {
        String beanName = (requestType == RequestType.subscription ? "webSocket" : "http") + "GraphQlClient" + (graphQLSchema == null ? "" : graphQLSchema);
        GraphQlClient bean = (GraphQlClient)applicationContext.getBean(beanName, GraphQlClient.class);
        logger.debug("Retrieving the '{}' bean (@{})", (Object)beanName, (Object)bean);
        return bean;
    }
}

