/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.graphqlrepository;

import com.graphql_java_generator.annotation.RequestType;
import com.graphql_java_generator.client.GraphQLMutationExecutor;
import com.graphql_java_generator.client.GraphQLMutationReactiveExecutor;
import com.graphql_java_generator.client.GraphQLQueryExecutor;
import com.graphql_java_generator.client.GraphQLQueryReactiveExecutor;
import com.graphql_java_generator.client.GraphQLSubscriptionExecutor;
import com.graphql_java_generator.client.GraphQLSubscriptionReactiveExecutor;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.graphqlrepository.BindParameter;
import com.graphql_java_generator.client.graphqlrepository.FullRequest;
import com.graphql_java_generator.client.graphqlrepository.GraphQLReactiveRepository;
import com.graphql_java_generator.client.graphqlrepository.GraphQLRepository;
import com.graphql_java_generator.client.graphqlrepository.PartialRequest;
import com.graphql_java_generator.client.request.AbstractGraphQLRequest;
import com.graphql_java_generator.client.request.ObjectResponse;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class GraphQLRepositoryInvocationHandler<T>
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(GraphQLRepositoryInvocationHandler.class);
    static GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils;
    final Class<T> repositoryInterface;
    final T proxyInstance;
    final Object queryExecutor;
    final Object mutationExecutor;
    final Object subscriptionExecutor;
    Map<Method, RegisteredMethod> registeredMethods = new HashMap<Method, RegisteredMethod>();

    public GraphQLRepositoryInvocationHandler(Class<T> repositoryInterface, ApplicationContext ctx) throws GraphQLRequestPreparationException {
        Package executorPackage;
        logger.trace("Creating a new GraphQLRepositoryInvocationHandler for the GraphQL Repository {}", (Object)repositoryInterface.getName());
        this.repositoryInterface = repositoryInterface;
        GraphQLRepository graphQLRepoAnnotation = repositoryInterface.getAnnotation(GraphQLRepository.class);
        GraphQLReactiveRepository graphQLReactiveRepoAnnotation = repositoryInterface.getAnnotation(GraphQLReactiveRepository.class);
        if (graphQLRepoAnnotation != null) {
            executorPackage = graphQLRepoAnnotation.queryExecutor() == GraphQLQueryExecutor.class ? null : graphQLRepoAnnotation.queryExecutor().getPackage();
            this.queryExecutor = this.getBeanOfTypeAndPackage(ctx, executorPackage, GraphQLQueryExecutor.class, true);
            this.mutationExecutor = this.getBeanOfTypeAndPackage(ctx, executorPackage, GraphQLMutationExecutor.class, false);
            this.subscriptionExecutor = this.getBeanOfTypeAndPackage(ctx, executorPackage, GraphQLSubscriptionExecutor.class, false);
        } else if (graphQLReactiveRepoAnnotation != null) {
            executorPackage = graphQLReactiveRepoAnnotation.queryExecutor() == GraphQLQueryReactiveExecutor.class ? null : graphQLReactiveRepoAnnotation.queryExecutor().getPackage();
            this.queryExecutor = this.getBeanOfTypeAndPackage(ctx, executorPackage, GraphQLQueryReactiveExecutor.class, true);
            this.mutationExecutor = this.getBeanOfTypeAndPackage(ctx, executorPackage, GraphQLMutationReactiveExecutor.class, false);
            this.subscriptionExecutor = this.getBeanOfTypeAndPackage(ctx, executorPackage, GraphQLSubscriptionReactiveExecutor.class, false);
        } else {
            throw new GraphQLRequestPreparationException("The '" + repositoryInterface.getName() + "' class has been passed to the GraphQLRepositoryInvocationHandler constructor as a GraphQLRepository. It should be annotated by one of these annotations: '" + GraphQLRepository.class.getName() + "' or '" + GraphQLReactiveRepository.class.getName() + "'");
        }
        logger.trace("The executors found are: queryExecutor={}, mutationExecutor={}, subscriptionExecutor={}", new Object[]{this.queryExecutor == null ? null : this.queryExecutor.getClass().getName(), this.mutationExecutor == null ? null : this.mutationExecutor.getClass().getName(), this.subscriptionExecutor == null ? null : this.subscriptionExecutor.getClass().getName()});
        if (this.queryExecutor == null) {
            if (executorPackage == null) {
                throw new RuntimeException("Error while preparing the GraphQL Repository '" + repositoryInterface.getName() + "': found no Spring Bean of type QueryExecutor'. Please check the Spring component scan path.");
            }
            throw new IllegalArgumentException("Error while preparing the GraphQL Repository '" + repositoryInterface.getName() + "': found no Spring Bean of type 'GraphQLQueryExecutor' in the same package as the provided QueryExecutor (" + graphQLRepoAnnotation.queryExecutor().getName() + "). Please check the Spring component scan path.");
        }
        this.proxyInstance = this.createProxyInstance();
    }

    private T createProxyInstance() throws GraphQLRequestPreparationException {
        if (this.repositoryInterface == null) {
            throw new NullPointerException("'repositoryInterface' may not be null");
        }
        if (!this.repositoryInterface.isInterface()) {
            throw new RuntimeException("The 'repositoryInterface' (" + this.repositoryInterface.getName() + ") must be an interface, but it is not");
        }
        if (this.repositoryInterface.getAnnotation(GraphQLRepository.class) == null && this.repositoryInterface.getAnnotation(GraphQLReactiveRepository.class) == null) {
            throw new GraphQLRequestPreparationException("This InvocationHandler may only be called for GraphQL repositories. GraphQL repositories must be annotated with one of the '" + GraphQLRepository.class.getName() + "' or '" + GraphQLReactiveRepository.class.getName() + "' annotations. But the '" + this.repositoryInterface.getName() + "' is not.");
        }
        Class[] classes = new Class[]{this.repositoryInterface};
        Object t = Proxy.newProxyInstance(this.repositoryInterface.getClassLoader(), classes, (InvocationHandler)this);
        for (Method method : this.repositoryInterface.getDeclaredMethods()) {
            this.registeredMethods.put(method, this.registerMethod(method));
        }
        return (T)t;
    }

    <C> C getBeanOfTypeAndPackage(ApplicationContext ctx, Package pack, Class<? extends C> clazz, boolean mandatory) {
        logger.trace("[getBeanOfTypeAndPackage] Starting execution");
        if (pack == null) {
            Collection beans = ctx.getBeansOfType(clazz).values();
            logger.trace("[getBeanOfTypeAndPackage] pack is null, and beans size is ", (Object)beans.size());
            if (beans.size() == 0) {
                if (mandatory) {
                    throw new RuntimeException("Error while preparing the GraphQL Repository, on the method '" + this.repositoryInterface.getName() + ": at least one Spring Bean of type '" + clazz.getName() + "' is expected, but none have been found");
                }
                return null;
            }
            if (beans.size() == 1) {
                return (C)beans.iterator().next();
            }
            throw new RuntimeException("Error while preparing the GraphQL Repository, on the method '" + this.repositoryInterface.getName() + ": one Spring Bean of type '" + clazz.getName() + "' is expected, but " + beans.size() + " have been found. This usely occurs when you have more than one GraphQL schemas, and you are using GraphQL Repositories, and at least one of your GraphQLRepository annotation didn't provide the QueryExecutor (through its queryExecutor parameter)");
        }
        Collection beans = ctx.getBeansOfType(clazz).values();
        logger.trace("[getBeanOfTypeAndPackage] pack is not null, iterating through the '{}' beans (size={})", (Object)clazz.getName(), (Object)beans.size());
        for (Object bean : beans) {
            logger.trace("[getBeanOfTypeAndPackage]    iterating on bean {}", bean.getClass());
            if (bean.getClass().getPackage() != pack) continue;
            logger.trace("[getBeanOfTypeAndPackage]      found bean {}: we're done", bean.getClass());
            return (C)bean;
        }
        logger.trace("[getBeanOfTypeAndPackage]    No bean found");
        return null;
    }

    T getProxyInstance() {
        return this.proxyInstance;
    }

    private RegisteredMethod registerMethod(Method method) throws GraphQLRequestPreparationException {
        RegisteredMethod registeredMethod = new RegisteredMethod();
        if (!Arrays.asList(method.getExceptionTypes()).contains(GraphQLRequestExecutionException.class)) {
            throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + method.getDeclaringClass().getName() + "." + method.getName() + "(..). Every method of GraphQL repositories must throw the 'com.graphql_java_generator.exception.GraphQLRequestExecutionException' exception, but the '" + method.getName() + "' doesn't");
        }
        PartialRequest partialRequest = method.getAnnotation(PartialRequest.class);
        FullRequest fullRequest = method.getAnnotation(FullRequest.class);
        if (partialRequest != null) {
            this.registerMethod(registeredMethod, method, false, partialRequest.requestName(), partialRequest.requestType(), partialRequest.request());
        } else if (fullRequest != null) {
            this.registerMethod(registeredMethod, method, true, null, fullRequest.requestType(), fullRequest.request());
        } else {
            throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + method.getDeclaringClass().getName() + "." + method.getName() + "(..). Every method of GraphQL repositories must be annotated by either @PartialRequest or @FullRequest. But the '" + method.getName() + "()' isn't.");
        }
        return registeredMethod;
    }

    private void registerMethod(RegisteredMethod registeredMethod, Method method, boolean fullRequest, String requestName, RequestType requestType, String request) throws GraphQLRequestPreparationException {
        registeredMethod.method = method;
        registeredMethod.fullRequest = fullRequest;
        registeredMethod.requestName = requestName;
        registeredMethod.requestType = requestType;
        registeredMethod.executor = this.getExecutor(method, requestType);
        this.registerParameters(registeredMethod, method);
        if (fullRequest) {
            registeredMethod.executorMethodName = "execWithBindValues";
            registeredMethod.executorGetGraphQLRequestMethodName = "getGraphQLRequest";
        } else if (registeredMethod.requestName == null || registeredMethod.requestName.equals("")) {
            registeredMethod.executorMethodName = method.getName() + "WithBindValues";
            registeredMethod.executorGetGraphQLRequestMethodName = "get" + graphqlUtils.getPascalCase(method.getName()) + "GraphQLRequest";
        } else {
            registeredMethod.executorMethodName = registeredMethod.requestName + "WithBindValues";
            registeredMethod.executorGetGraphQLRequestMethodName = "get" + graphqlUtils.getPascalCase(registeredMethod.requestName) + "GraphQLRequest";
        }
        try {
            registeredMethod.executorMethod = registeredMethod.executor.getClass().getMethod(registeredMethod.executorMethodName, registeredMethod.executorParameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            StringBuilder parameters = new StringBuilder();
            String separator = "";
            for (Class<?> clazz : registeredMethod.executorParameterTypes) {
                parameters.append(separator);
                parameters.append(clazz.getName());
                separator = ",";
            }
            throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + method.getDeclaringClass().getName() + "." + method.getName() + "(..). Couldn't find the matching executor method '" + registeredMethod.executorMethodName + "' for executor class '" + registeredMethod.executor.getClass().getName() + "' with these parameters: [" + parameters + "]. Consider marking bind parameters and GraphQL variables with the @BindParameter annotation.", e);
        }
        if (!method.getReturnType().isAssignableFrom(registeredMethod.executorMethod.getReturnType())) {
            throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + method.getDeclaringClass().getName() + "." + method.getName() + "(..). This method should return " + registeredMethod.executorMethod.getReturnType().getName() + " but returns " + method.getReturnType().getName() + " (and the later can not be assigned to the former)");
        }
        registeredMethod.request = request;
        registeredMethod.graphQLRequest = this.getGraphQLRequest(registeredMethod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerParameters(RegisteredMethod registeredMethod, Method method) throws GraphQLRequestPreparationException {
        ArrayList executorParameterTypes = new ArrayList();
        executorParameterTypes.add(ObjectResponse.class);
        boolean foundBindParameterAnnotation = false;
        for (Parameter param : method.getParameters()) {
            RegisteredParameter regParam = new RegisteredParameter();
            regParam.name = param.getName();
            switch (param.getType().getName()) {
                case "boolean": {
                    regParam.type = Boolean.class;
                    break;
                }
                case "double": {
                    regParam.type = Double.class;
                    break;
                }
                case "float": 
                case "java.lang.Float": {
                    throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + registeredMethod.method.getDeclaringClass().getName() + "." + registeredMethod.method.getName() + "(..). Float and float parameter types are not allowed. Please note that the GraphQL Float type maps to the Double java type.");
                }
                case "int": {
                    regParam.type = Integer.class;
                    break;
                }
                default: {
                    regParam.type = param.getType();
                }
            }
            if (Map.class.isAssignableFrom(regParam.type) || Object[].class.isAssignableFrom(regParam.type)) {
                throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + registeredMethod.method.getDeclaringClass().getName() + "." + registeredMethod.method.getName() + "(..). Map and vararg (Object[]) are not allowed. But the '" + param.getName() + "' is an instance of '" + param.getType().getName() + "'");
            }
            BindParameter bindParameter = param.getAnnotation(BindParameter.class);
            if (bindParameter == null) {
                if (registeredMethod.fullRequest) {
                    if (!param.getAnnotatedType().getType().getTypeName().startsWith(SubscriptionCallback.class.getName())) throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + registeredMethod.method.getDeclaringClass().getName() + "." + registeredMethod.method.getName() + "(..). This request is a full request: all its parameters must be marked with the '" + BindParameter.class.getSimpleName() + "' annotation. But the '" + param.getName() + "' isn't marked with this annotation.");
                    executorParameterTypes.add(regParam.type);
                } else {
                    if (foundBindParameterAnnotation) {
                        throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + registeredMethod.method.getDeclaringClass().getName() + "." + registeredMethod.method.getName() + "(..). It is not allowed to have parameters without the '" + BindParameter.class.getSimpleName() + "' annotation, after parameters that have this annotation. The '" + param.getName() + "' parameter lacks the '" + BindParameter.class.getSimpleName() + "' annotation.");
                    }
                    executorParameterTypes.add(regParam.type);
                }
            } else {
                foundBindParameterAnnotation = true;
                regParam.bindParameterName = bindParameter.name();
            }
            registeredMethod.registeredParameters.add(regParam);
        }
        executorParameterTypes.add(Map.class);
        registeredMethod.executorParameterTypes = new Class[executorParameterTypes.size()];
        for (int i = 0; i < registeredMethod.executorParameterTypes.length; ++i) {
            registeredMethod.executorParameterTypes[i] = (Class)executorParameterTypes.get(i);
        }
        logger.debug("The expected parameter types for the '{}.{}' method are: {}", new Object[]{method.getDeclaringClass().getName(), method.getName(), registeredMethod.executorParameterTypes});
    }

    private AbstractGraphQLRequest getGraphQLRequest(RegisteredMethod registeredMethod) throws GraphQLRequestPreparationException {
        Method getGraphQlMethod;
        try {
            getGraphQlMethod = registeredMethod.executor.getClass().getDeclaredMethod(registeredMethod.executorGetGraphQLRequestMethodName, String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + registeredMethod.method.getDeclaringClass().getName() + "." + registeredMethod.method.getName() + "(..). Could not find the '" + registeredMethod.executorGetGraphQLRequestMethodName + " method of the '" + registeredMethod.executor.getClass().getName() + "' class.");
        }
        try {
            return (AbstractGraphQLRequest)getGraphQlMethod.invoke(registeredMethod.executor, registeredMethod.request);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new GraphQLRequestPreparationException("Error while preparing the GraphQL Repository, on the method '" + registeredMethod.method.getDeclaringClass().getName() + "." + registeredMethod.method.getName() + "(..): " + e.getClass().getSimpleName() + " when trying to invoke the '" + registeredMethod.executorGetGraphQLRequestMethodName + "' method of the '" + registeredMethod.executor.getClass().getName() + "' class", e);
        }
    }

    private Object getExecutor(Method method, RequestType requestType) throws GraphQLRequestPreparationException {
        switch (requestType) {
            case query: {
                return this.queryExecutor;
            }
            case mutation: {
                return this.mutationExecutor;
            }
            case subscription: {
                return this.subscriptionExecutor;
            }
        }
        throw new GraphQLRequestPreparationException("The '" + method.getDeclaringClass().getName() + "." + method.getName() + "()' method refers to a '" + requestType.toString() + "', but there is no such executor found. Check if the GraphQL has such a request type defined.");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RegisteredMethod registeredMethod = this.registeredMethods.get(method);
        if (registeredMethod == null) {
            if (method.getName().equals("hashCode")) {
                return 1;
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke(proxy, args);
            }
            throw new GraphQLRequestExecutionException("The method '" + method.getDeclaringClass().getName() + "." + method.getName() + "' has not been stored in initialization phase of this InvocationHandler. Is this method coming from the right interface? (that is, the same as the one this InvocationHandler has been created with?)");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        HashMap<String, Object> bindParameters = new HashMap<String, Object>();
        params.add(registeredMethod.graphQLRequest);
        if ((args == null ? 0 : args.length) != registeredMethod.registeredParameters.size()) {
            throw new GraphQLRequestExecutionException("Error while invoking the '" + method.getDeclaringClass() + "." + method.getName() + "': the proxy invocation handler receives " + (args == null ? 0 : args.length) + ", but it has registered " + registeredMethod.registeredParameters.size() + " parameters");
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                RegisteredParameter regParam = registeredMethod.registeredParameters.get(i);
                if (regParam.bindParameterName == null) {
                    params.add(args[i]);
                    continue;
                }
                bindParameters.put(regParam.bindParameterName, args[i]);
            }
        }
        params.add(bindParameters);
        try {
            return registeredMethod.executorMethod.invoke(registeredMethod.executor, params.toArray());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    class RegisteredMethod {
        Method method;
        boolean fullRequest;
        String request;
        String requestName;
        RequestType requestType;
        String executorMethodName;
        String executorGetGraphQLRequestMethodName;
        Object executor;
        Method executorMethod;
        AbstractGraphQLRequest graphQLRequest;
        public Class<?>[] executorParameterTypes;
        List<RegisteredParameter> registeredParameters = new ArrayList<RegisteredParameter>();

        RegisteredMethod() {
        }
    }

    class RegisteredParameter {
        String name;
        public Class<?> type;
        String bindParameterName;

        RegisteredParameter() {
        }
    }
}

