/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.handler.ConnectionThrottler;
import com.sun.net.httpserver.HttpExchange;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerExchangeThrottler
extends ConnectionThrottler {
    private final Map<InetAddress, AtomicInteger> connections = new ConcurrentHashMap<InetAddress, AtomicInteger>();
    private final AtomicInteger uConn = new AtomicInteger(0);
    private final AtomicInteger uConnMax = new AtomicInteger(-1);

    public ServerExchangeThrottler() {
    }

    public ServerExchangeThrottler(int maxConnections) {
        this.uConnMax.set(maxConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final boolean addConnection(HttpExchange exchange) {
        InetAddress address = exchange.getRemoteAddress().getAddress();
        int maxConn = this.getMaxConnections(exchange);
        if (!this.connections.containsKey(address)) {
            this.connections.put(address, new AtomicInteger(0));
        }
        AtomicInteger conn = this.connections.get(address);
        boolean exempt = this.canIgnoreConnectionLimit(exchange);
        if (maxConn < 0) {
            if (!exempt) {
                ServerExchangeThrottler serverExchangeThrottler = this;
                synchronized (serverExchangeThrottler) {
                    int umax = this.uConnMax.get();
                    if (umax < 0 || this.uConn.get() < umax) {
                        conn.incrementAndGet();
                        this.uConn.incrementAndGet();
                        return true;
                    }
                    return false;
                }
            }
            conn.incrementAndGet();
            return true;
        }
        if (!exempt) {
            ServerExchangeThrottler serverExchangeThrottler = this;
            synchronized (serverExchangeThrottler) {
                int umax = this.uConnMax.get();
                if (conn.get() < maxConn && (umax < 0 || this.uConn.get() < umax)) {
                    conn.incrementAndGet();
                    this.uConn.incrementAndGet();
                    return true;
                }
                return false;
            }
        }
        AtomicBoolean added = new AtomicBoolean(false);
        conn.updateAndGet(operand -> {
            if (operand < maxConn) {
                added.set(true);
            }
            return operand < maxConn ? operand + 1 : operand;
        });
        return added.get();
    }

    @Override
    final void deleteConnection(HttpExchange exchange) {
        InetAddress address = exchange.getRemoteAddress().getAddress();
        if (this.connections.containsKey(address)) {
            this.connections.get(address).decrementAndGet();
            if (!this.canIgnoreConnectionLimit(exchange)) {
                this.uConn.decrementAndGet();
            }
        }
    }

    @Override
    public int getMaxConnections(HttpExchange exchange) {
        return -1;
    }

    public boolean canIgnoreConnectionLimit(HttpExchange exchange) {
        return false;
    }

    public final synchronized void setMaxServerConnections(int connections) {
        this.uConnMax.set(connections);
    }

    public final synchronized int getMaxServerConnections() {
        return this.uConnMax.get();
    }

    public String toString() {
        return "ServerExchangeThrottler{connections=" + this.connections.toString() + ", userConnections=" + this.uConn + ", userConnectionsMax=" + this.uConnMax + "}";
    }
}

